/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.utils;

import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DataModelScaExtractor {
    public static Set<String> extractScaServiceDescriptionIds(byte[] dataModelData) throws AbstractSVCException {
        Document doc;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(dataModelData);
            doc = XmlUtils.createDoc(bis);
        }
        catch (Exception e) {
            try {
                throw new SVCParseException("Failed to parse data model", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bis);
        if (doc != null) {
            try {
                return DataModelScaExtractor.extract(doc);
            }
            catch (Exception e) {
                throw new SVCParseException("SCA Service Description IDs extraction failed", e);
            }
        }
        return null;
    }

    private static Set<String> extract(Document doc) {
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new IllegalStateException("No dataModel element found");
        }
        NodeList list = root.getElementsByTagName("serviceOperations");
        if (list == null) {
            throw new IllegalStateException("No serviceOperations element found");
        }
        if (list.getLength() == 0) {
            return null;
        }
        Element child = (Element)list.item(0);
        if ((list = child.getElementsByTagName("serviceOperation")) == null) {
            throw new IllegalStateException("No serviceOperations element found");
        }
        if (list.getLength() == 0) {
            return null;
        }
        HashSet<String> sdIds = new HashSet<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            String sdId;
            Element sca;
            int j;
            child = (Element)list.item(i);
            NodeList activitiesList = child.getElementsByTagName("activities");
            if (activitiesList == null || activitiesList.getLength() != 1) {
                throw new IllegalStateException("No activities element found");
            }
            Element activities = (Element)activitiesList.item(0);
            NodeList scaList = activities.getElementsByTagName("serviceCallActivity");
            if (scaList != null) {
                for (j = 0; j < scaList.getLength(); ++j) {
                    sca = (Element)scaList.item(j);
                    sdId = sca.getAttribute("serviceDescriptionId");
                    if (sdId == null) continue;
                    sdIds.add(sdId);
                }
            }
            if ((scaList = activities.getElementsByTagName("postResponseServiceCallActivity")) == null) continue;
            for (j = 0; j < scaList.getLength(); ++j) {
                sca = (Element)scaList.item(j);
                sdId = sca.getAttribute("serviceDescriptionId");
                if (sdId == null) continue;
                sdIds.add(sdId);
            }
        }
        return sdIds;
    }
}

