/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.utils;

import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;

public class DataModelContentFilesExtractor {
    public static void extractContentFileIds(byte[] dataModelData, Set<String> includedFileIds) throws SVCParseException {
        Document doc;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(dataModelData);
            doc = XmlUtils.createDoc(bis);
        }
        catch (Exception e) {
            try {
                throw new SVCParseException("Failed to parse data model", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bis);
        if (doc != null) {
            try {
                DataModelContentFilesExtractor.extract(doc, includedFileIds);
            }
            catch (Exception e) {
                throw new SVCParseException("Content File IDs extraction failed", e);
            }
        }
    }

    private static void extract(Document doc, Set<String> includedFileIds) throws XPathExpressionException {
        for (String includedFileId : XmlUtils.evalCollectionXpath("//*[local-name()='includedFile']/@includedFileId", doc)) {
            includedFileIds.add(includedFileId);
        }
    }
}

