/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.export;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.processor.export.AbstractWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderWriter
extends AbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(FolderWriter.class);
    File projectFolder;

    public FolderWriter(File root, String projectName) throws CommandExecutorException {
        String folderName = FolderWriter.entityNameToFileName(projectName);
        this.projectFolder = new File(root, folderName);
        if (this.projectFolder.exists()) {
            this.projectFolder = new File(root, folderName + "-" + UUID.randomUUID());
        }
        if (!this.projectFolder.exists()) {
            if (!this.projectFolder.mkdirs()) {
                throw new CommandExecutorException("Cannot create directory: " + this.projectFolder);
            }
        } else {
            throw new CommandExecutorException("Directory already exists: " + this.projectFolder);
        }
        LOG.info("Saving project '" + projectName + "' to '" + this.projectFolder + "'...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeDataImpl(byte[] data, String filePath) throws IOException {
        File f = new File(this.projectFolder, filePath);
        try (FileOutputStream fos = new FileOutputStream(f);){
            fos.write(data);
        }
    }
}

