/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl.jaxb.atom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.AbstractEntry;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.AbstractFeed;
import com.microfocus.sv.svconfigurator.processor.printer.NonPrintable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="feed", namespace="http://www.w3.org/2005/Atom")
public class ServiceListAtom
extends AbstractFeed<ServiceEntry> {
    private List<ServiceEntry> entries = new ArrayList<ServiceEntry>();

    @Override
    @XmlElement(name="entry", namespace="http://www.w3.org/2005/Atom")
    public List<ServiceEntry> getEntries() {
        return this.entries;
    }

    @Override
    public void setEntries(List<ServiceEntry> entry) {
        this.entries = entry;
    }

    public static class ServiceEntry
    extends AbstractEntry {
        private String serviceMode;
        private String deployState;
        private String deploymentError;
        private String projectName;
        private String clientId;
        private String dataModel;
        private String perfModel;
        private String projectId;
        @NonPrintable
        private String runtimeIssues;
        private String runtimeIssuesParsed;
        @NonPrintable
        private String nonExistentRealService;

        @XmlElement(name="ServiceMode")
        public String getServiceMode() {
            return this.serviceMode;
        }

        public void setServiceMode(String serviceMode) {
            this.serviceMode = serviceMode;
        }

        @XmlElement(name="VirtualServiceDeploymentState")
        public String getDeployState() {
            return this.deployState;
        }

        public void setDeployState(String deployState) {
            this.deployState = deployState;
        }

        @XmlElement(name="VirtualServiceDeploymentErrorMessage")
        public String getDeploymentError() {
            return this.deploymentError;
        }

        public void setDeploymentError(String deploymentError) {
            this.deploymentError = deploymentError;
        }

        @XmlElement(name="ProjectName")
        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @XmlElement(name="SessionClientId")
        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @XmlElement(name="DataModelId")
        public String getDataModel() {
            return this.dataModel;
        }

        public void setDataModel(String dataModel) {
            this.dataModel = dataModel;
        }

        @XmlElement(name="PerformanceModelId")
        public String getPerfModel() {
            return this.perfModel;
        }

        public void setPerfModel(String perfModel) {
            this.perfModel = perfModel;
        }

        @XmlElement(name="ProjectId")
        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @XmlElement(name="RuntimeIssues")
        public String getRuntimeIssues() {
            return this.runtimeIssues;
        }

        public void setRuntimeIssues(String runtimeIssues) {
            this.runtimeIssues = runtimeIssues;
            this.runtimeIssuesParsed = this.ParseRuntimeIssues();
        }

        private String ParseRuntimeIssues() {
            JsonParser jsonParser = new JsonParser();
            try {
                String result = "";
                JsonObject issuesJson = jsonParser.parse(this.runtimeIssues).getAsJsonObject();
                JsonArray issuesArr = issuesJson.getAsJsonArray("issues");
                for (JsonElement issue : issuesArr) {
                    JsonObject issueJson = issue.getAsJsonObject();
                    RuntimeIssue i = new RuntimeIssue();
                    i.type = issueJson.get("type").getAsString();
                    i.agentName = issueJson.get("agentName").getAsString();
                    if (i.type.equals("endpointDown")) {
                        i.endpointName = issueJson.get("endpointName").getAsString();
                    }
                    result = result + i.Format() + ", ";
                }
                return result.length() == 0 ? "No Issues" : result.substring(0, result.length() - 2);
            }
            catch (Exception e) {
                return "Cannot parse";
            }
        }

        public String getRuntimeIssuesParsed() {
            return this.runtimeIssuesParsed;
        }

        @XmlElement(name="NonExistentRealService")
        public String getNonExistentRealService() {
            return this.nonExistentRealService;
        }

        public void setNonExistentRealService(String nonExistentRealService) {
            this.nonExistentRealService = nonExistentRealService;
        }

        private class RuntimeIssue {
            public String type;
            public String agentName;
            public String endpointName;

            private RuntimeIssue() {
            }

            public String Format() {
                return (this.type.equals("agentDown") ? "Agent " + this.agentName : "Endpoint " + this.endpointName) + " is down";
            }
        }

        public static class HashCodeObj {
            private String hashCode;
            private String value;

            @XmlElement(name="hashCode", namespace="http://schemas.datacontract.org/2004/07/HP.SOAQ.ServiceVirtualization.Model.Api.Common")
            public String getHashCode() {
                return this.hashCode;
            }

            public void setHashCode(String hashCode) {
                this.hashCode = hashCode;
            }

            @XmlElement(name="value", namespace="http://schemas.datacontract.org/2004/07/HP.SOAQ.ServiceVirtualization.Model.Api.Common")
            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

