/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl;

import com.microfocus.sv.svconfigurator.core.AbstractProjectElement;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IDataSet;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.IProjectElementVisitor;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.encryption.EncryptionMetadata;
import com.microfocus.sv.svconfigurator.processor.printer.NonPrintable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DataModel
extends AbstractProjectElement
implements IDataModel {
    @NonPrintable
    private Set<IDataSet> dataSets = new HashSet<IDataSet>();
    @NonPrintable
    private IService service;

    public DataModel(String id, String name, IProjectElementDataSource ds, EncryptionMetadata encryptionMetadata, String projectPassword) {
        super(id, name, ds, encryptionMetadata, projectPassword);
    }

    @Override
    public int compareTo(IDataModel o) {
        if (this.getName() == null) {
            return o.getName() == null ? 0 : -1;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public void accept(IProjectElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Collection<IDataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public void addDataSet(IDataSet ds) {
        this.dataSets.add(ds);
        ds.setDataModel(this);
    }

    @Override
    public IService getService() {
        if (this.service == null) {
            throw new IllegalStateException("Data Model is not initialized, it does not belong to any ReferenceElement.");
        }
        return this.service;
    }

    @Override
    public void setService(IService service) {
        if (this.service != null) {
            throw new IllegalStateException("Data Model can belong only to one service.");
        }
        this.service = service;
    }
}

