/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.DeployCLICommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.IUndeployProcessor;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import com.microfocus.sv.svconfigurator.util.StringUtils;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndeployCLICommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    public static final String COMMAND = "undeploy";
    private static final String HELP_USAGE = "undeploy [parameters]";
    private static final String PARAM_FORCE = "f";
    private static final String LONG_PARAM_FORCE = "force";
    private static final String PARAM_SERVICE = "s";
    private static final String LONG_PARAM_SERVICE = "service";
    private static final Logger LOG = LoggerFactory.getLogger(DeployCLICommandProcessor.class);
    private IUndeployProcessor proc;
    private Options opts;

    public UndeployCLICommandProcessor(IProjectBuilder projectBuilder, IUndeployProcessor proc) {
        super(projectBuilder);
        this.proc = proc;
        this.opts = this.createParamOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            String svc;
            CommandLine line = parser.parse(this.opts, args);
            if (line.getArgList().size() > 0) {
                throw new ParseException("Unknown parameters: " + StringUtils.joinWithDelim("", line.getArgList()));
            }
            IProject proj = this.getProject(line);
            List<Server> servers = CliUtils.obtainServers(line, proj);
            boolean force = line.hasOption(PARAM_FORCE);
            String string = svc = line.hasOption(PARAM_SERVICE) ? line.getOptionValue(PARAM_SERVICE) : null;
            if (svc == null && proj == null) {
                throw new ParseException("Either project or service have to be specified.");
            }
            final UndeployProcessorInput input = new UndeployProcessorInput(force, proj, svc);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.proc.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    UndeployCLICommandProcessor.this.proc.process(input, executor);
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), e);
            CliUtils.printHelp(HELP_USAGE, this.opts, null);
            return 1000;
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage(), e);
            CliUtils.printHelp(HELP_USAGE, this.opts, null);
            return 1000;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1100;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1200;
        }
        catch (CommandExecutorException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1300;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1500;
        }
        return 0;
    }

    private Options createParamOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PARAM_FORCE, LONG_PARAM_FORCE, false, "Force the undeployment. This parameter is used when the service that we want to undeploy is locked by another user. Force mode overrides the lock. Be carefull with this options.");
        opts.addOption(PARAM_SERVICE, LONG_PARAM_SERVICE, true, "If you specify this parameter, only the specified service will be undeployed.");
        opts.addOption("p", "project", true, "Project to be undeployed.");
        opts.addOption("w", "project-password", true, "Project encryption password.");
        return opts;
    }
}

