/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.ICLICommandRegistry;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CLICommandRegistry
implements ICLICommandRegistry {
    private static final String USAGE = "Usage: <COMMAND> [parameters]\nYou must select one of the following command:\n";
    private Map<String, ICLICommandProcessorFactory> factoryMap = null;

    public CLICommandRegistry(Collection<ICLICommandProcessorFactory> commandProcessorFactories) {
        this.factoryMap = new HashMap<String, ICLICommandProcessorFactory>(commandProcessorFactories.size());
        for (ICLICommandProcessorFactory factory : commandProcessorFactories) {
            this.factoryMap.put(factory.getCommand().toUpperCase(), factory);
        }
    }

    @Override
    public ICLICommandProcessor lookupCommandProcessor(String command) throws SVCParseException {
        String upperCommand = command.toUpperCase();
        if (!this.factoryMap.containsKey(upperCommand)) {
            throw new SVCParseException("Command " + command + " was not found in the CLICommandProcessor registry.");
        }
        ICLICommandProcessorFactory factory = this.factoryMap.get(upperCommand);
        return factory.create();
    }

    @Override
    public String getCLICommandHelp() {
        HelpFormatter f = new HelpFormatter();
        f.setOptPrefix("");
        f.setLongOptPrefix("");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        f.printHelp(pw, f.getWidth(), USAGE, "", this.createOptions(), f.getLeftPadding(), f.getDescPadding(), "");
        pw.close();
        return sw.toString();
    }

    private Options createOptions() {
        Options opts = new Options();
        for (ICLICommandProcessorFactory factory : this.factoryMap.values()) {
            OptionBuilder.withLongOpt(factory.getCommand());
            OptionBuilder.withDescription(factory.getDescription());
            opts.addOption(OptionBuilder.create());
        }
        return opts;
    }
}

