/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build.parser;

import com.microfocus.sv.svconfigurator.build.parser.AbstractXMLElementParser;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.Project;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

public class ProjectElementParser
extends AbstractXMLElementParser {
    private static final String FILE_SUFFIX = ".vproj";
    private static final String ELEMENT_PROJ_GUID = "ProjectGuid";
    private static final String ELEMENT_PROJ_SERVER_URL = "ServerUrl";

    @Override
    public IProjectElement create(IProjectElementDataSource ds, XMLEventReader reader, String projectPassword) throws SVCParseException, XMLStreamException {
        AbstractXMLElementParser.skipToElement(reader, ELEMENT_PROJ_GUID);
        String id = reader.getElementText();
        String name = StringUtils.removeSuffix(ds.getName(), FILE_SUFFIX);
        AbstractXMLElementParser.skipToElement(reader, ELEMENT_PROJ_SERVER_URL);
        String uriStr = reader.getElementText();
        URL uri = null;
        if (uriStr != null && !uriStr.trim().isEmpty()) {
            try {
                uri = new URL(uriStr);
            }
            catch (MalformedURLException e) {
                throw new SVCParseException("Failed to parser project's server URL '" + uriStr + "'", e);
            }
        }
        return new Project(id, name, projectPassword, uri, ds);
    }

    @Override
    public boolean isParserForDataSource(IProjectElementDataSource ds) {
        return ds.getName().endsWith(FILE_SUFFIX);
    }
}

