/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.Global;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutor;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.HttpUtils;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UnlockTask
extends Task {
    private String service;
    private String username;
    private String password;
    private String url;
    private boolean trustEveryone = false;
    private boolean lock;

    public void execute() throws BuildException {
        this.validate();
        URL mgmtUri = AntTaskUtil.createUri(this.url, null);
        Credentials cred = ProjectUtils.createCredentials(this.username, this.password);
        try {
            CommandExecutor exec = new CommandExecutor(HttpUtils.createServerManagementEndpointClient(mgmtUri, this.trustEveryone, cred));
            IService svc = exec.findService(this.service, null);
            String clientId = this.lock ? Global.getClientId(exec) : null;
            exec.lockService(svc, clientId);
            this.getProject().log("Service lock change successfully processed.");
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CommandExecutorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validate() throws BuildException {
        if (this.service == null) {
            throw new BuildException("Service identification (service) has to be set.");
        }
        if (this.url == null) {
            throw new BuildException("Server management URL (url) have to be set.");
        }
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }
}

