/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import com.jayway.jsonpath.internal.token.PathToken;
import java.util.List;

public class PropertyPathToken
extends PathToken {
    private final List<String> properties;

    public PropertyPathToken(List<String> properties) {
        this.properties = properties;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    @Override
    public void evaluate(String currentPath, Object model, EvaluationContextImpl ctx) {
        if (!ctx.jsonProvider().isMap(model)) {
            throw new PathNotFoundException("Property " + this.getPathFragment() + " not found in path " + currentPath);
        }
        this.handleObjectProperty(currentPath, model, ctx, this.properties);
    }

    @Override
    boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "[" + Utils.join(", ", "'", this.properties) + "]";
    }
}

