/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk.handler;

import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.XPathUtils;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.Logger;
import com.adm.utils.uft.sdk.Response;
import com.adm.utils.uft.sdk.handler.PollHandler;
import com.adm.utils.uft.sdk.request.GetPCRunEntityDataRequest;
import java.util.Arrays;
import java.util.List;

public class PCPollHandler
extends PollHandler {
    private static final List<String> FINAL_STATES = Arrays.asList("N/A", "Failed", "Passed");

    public PCPollHandler(Client client, String entityId) {
        super(client, entityId);
    }

    public PCPollHandler(Client client, String entityId, int interval) {
        super(client, entityId, interval);
    }

    @Override
    protected Response getResponse() {
        return new GetPCRunEntityDataRequest(this._client, this._runId).execute();
    }

    @Override
    protected boolean isFinished(Response response, Logger logger) {
        boolean ret = false;
        try {
            String xml = response.toString();
            String pcEndTime = XPathUtils.getAttributeValue(xml, "pc-end-time");
            String status = XPathUtils.getAttributeValue(xml, "status");
            if (!StringUtils.isNullOrEmpty(pcEndTime)) {
                logger.log(String.format("PC test end time: %s", pcEndTime));
                ret = true;
            } else if (!StringUtils.isNullOrEmpty(status) && FINAL_STATES.contains(status)) {
                ret = true;
            }
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response: %s", response));
            ret = true;
        }
        return ret;
    }

    @Override
    protected boolean logRunEntityResults(Response response, Logger logger) {
        boolean ret = false;
        try {
            String xml = response.toString();
            String status = XPathUtils.getAttributeValue(xml, "status");
            String state = XPathUtils.getAttributeValue(xml, "state");
            logger.log(String.format("Run status of %s: %s, State: %s", this._runId, status, state));
            ret = true;
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response: %s", response));
        }
        return ret;
    }

    @Override
    protected Response getRunEntityResultsResponse() {
        return new GetPCRunEntityDataRequest(this._client, this._runId).execute();
    }
}

