/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.rest.RestClient;
import com.adm.utils.uft.result.PublisherFactory;
import com.adm.utils.uft.result.model.junit.Testsuites;
import com.adm.utils.uft.sdk.Args;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.Logger;
import com.adm.utils.uft.sdk.ResourceAccessLevel;
import com.adm.utils.uft.sdk.Response;
import com.adm.utils.uft.sdk.RestAuthenticator;
import com.adm.utils.uft.sdk.RunResponse;
import com.adm.utils.uft.sdk.handler.PollHandler;
import com.adm.utils.uft.sdk.handler.PollHandlerFactory;
import com.adm.utils.uft.sdk.handler.RunHandler;
import com.adm.utils.uft.sdk.handler.RunHandlerFactory;
import java.util.HashMap;

public class RunManager {
    private RunHandler _runHandler;
    private PollHandler _pollHandler;
    private Logger _logger;
    private boolean _running = false;
    private boolean _polling = false;
    private static final String CLIENT_TYPE = "ALM-CLIENT-TYPE";

    public Testsuites execute(RestClient client, Args args, Logger logger) throws InterruptedException {
        Testsuites ret = null;
        this._logger = logger;
        this._running = true;
        if (this.login(client, args)) {
            this.initialize(args, client);
            if (this.start(args)) {
                this._polling = true;
                if (this.poll()) {
                    ret = new PublisherFactory().create(client, args.getRunType(), args.getEntityId(), this._runHandler.getRunId()).publish(this._runHandler.getNameSuffix(), args.getUrl(), args.getDomain(), args.getProject(), logger);
                }
                this._polling = false;
            }
        }
        return ret;
    }

    private void initialize(Args args, RestClient client) {
        String entityId = args.getEntityId();
        this.appendQCSessionCookies(client);
        this._runHandler = new RunHandlerFactory().create(client, args.getRunType(), entityId);
        this._pollHandler = new PollHandlerFactory().create(client, args.getRunType(), entityId);
    }

    private void appendQCSessionCookies(RestClient client) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        headers.put("Accept", "application/xml");
        Response response = client.httpPost(client.build("rest/site-session"), this.generateClientTypeData(), headers, ResourceAccessLevel.PUBLIC);
        if (!response.isOk()) {
            throw new SSEException("Cannot append QCSession cookies", response.getFailure());
        }
    }

    private byte[] generateClientTypeData() {
        String data = String.format("<session-parameters><client-type>%s</client-type></session-parameters>", CLIENT_TYPE);
        return data.getBytes();
    }

    private boolean poll() throws InterruptedException {
        return this._pollHandler.poll(this._logger);
    }

    public void stop() {
        this._logger.log("Stopping run...");
        if (this._runHandler != null) {
            this._runHandler.stop();
            this._running = false;
        }
        if (this._pollHandler != null) {
            this._polling = false;
        }
    }

    private boolean login(Client client, Args args) {
        boolean ret = true;
        try {
            ret = Boolean.valueOf(args.getAlmSSO()).equals(true) ? new RestAuthenticator().loginWithApiKey(client, args.getClientId(), args.getApiKeySecret(), CLIENT_TYPE, this._logger) : new RestAuthenticator().login(client, args.getUsername(), args.getPassword(), this._logger);
        }
        catch (Throwable cause) {
            ret = false;
            this._logger.log(String.format("Failed login to ALM Server URL: %s. Exception: %s", args.getUrl(), cause.getMessage()));
        }
        return ret;
    }

    private boolean start(Args args) {
        boolean ret = false;
        Response response = this._runHandler.start(args.getDuration(), args.getPostRunAction(), args.getEnvironmentConfigurationId(), args.getCdaDetails());
        if (this.isOk(response, args)) {
            RunResponse runResponse = this.getRunResponse(response);
            this.setRunId(runResponse);
            if (runResponse.isSucceeded()) {
                ret = true;
            }
        }
        this.logReportUrl(ret, args);
        return ret;
    }

    private void setRunId(RunResponse runResponse) {
        String runId = runResponse.getRunId();
        if (StringUtils.isNullOrEmpty(runId)) {
            this._logger.log("No run ID");
            throw new SSEException("No run ID");
        }
        this._runHandler.setRunId(runId);
        this._pollHandler.setRunId(runId);
    }

    private void logReportUrl(boolean isSucceeded, Args args) {
        if (isSucceeded) {
            this._logger.log(String.format("%s run report for run id %s is at: %s", args.getRunType(), this._runHandler.getRunId(), this._runHandler.getReportUrl(args)));
        } else {
            this._logger.log(String.format("Failed to start %s ID:%s, run id: %s \nNote: You can run only functional test sets and build verification suites using this plugin. Check to make sure that the configured ID is valid (and that it is not a performance test ID).", args.getRunType(), args.getEntityId(), this._runHandler.getRunId()));
        }
    }

    private RunResponse getRunResponse(Response response) {
        return this._runHandler.getRunResponse(response);
    }

    private boolean isOk(Response response, Args args) {
        boolean ret = false;
        if (response.isOk()) {
            this._logger.log(String.format("Executing %s ID: %s in %s/%s %sDescription: %s", args.getRunType(), args.getEntityId(), args.getDomain(), args.getProject(), StringUtils.NEW_LINE, args.getDescription()));
            ret = true;
        } else {
            Throwable cause = response.getFailure();
            if (cause != null) {
                this._logger.log(String.format("Failed to start %s ID: %s, ALM Server URL: %s (Exception: %s)", args.getRunType(), args.getEntityId(), args.getUrl(), cause.getMessage()));
            } else {
                this._logger.log(String.format("Failed to execute %s ID: %s, ALM Server URL: %s (Response: %s)", args.getRunType(), args.getEntityId(), args.getUrl(), response.getStatusCode()));
            }
        }
        return ret;
    }

    public boolean getRunning() {
        return this._running;
    }

    public boolean getPolling() {
        return this._polling;
    }
}

