/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.rest.RestClient;
import com.adm.utils.uft.sdk.Base64Encoder;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.Logger;
import com.adm.utils.uft.sdk.ResourceAccessLevel;
import com.adm.utils.uft.sdk.Response;
import java.util.HashMap;

public class RestAuthenticator {
    public static final String IS_AUTHENTICATED = "rest/is-authenticated";
    public static String AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String APIKEY_LOGIN_API = "rest/oauth2/login";
    private static final String CLIENT_TYPE = "ALM-CLIENT-TYPE";

    public boolean loginWithApiKey(Client client, String clientId, String secret, String clientType, Logger logger) {
        logger.log("Start login to ALM server with APIkey...");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CLIENT_TYPE, clientType);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        Response response = client.httpPost(client.build(APIKEY_LOGIN_API), String.format("{clientId:%s, secret:%s}", clientId, secret).getBytes(), headers, ResourceAccessLevel.PUBLIC);
        boolean result = response.isOk();
        logger.log(result ? String.format("Logged in successfully to Application Quality Management Server %s using %s", client.getServerUrl(), clientId) : String.format("Login to Application Quality Management Server at %s failed. Status Code: %s", client.getServerUrl(), response.getStatusCode()));
        return result;
    }

    public boolean login(Client client, String username, String password, Logger logger) {
        boolean ret = true;
        String authenticationPoint = this.isAuthenticated(client, logger);
        if (authenticationPoint != null) {
            Response response = this.login(client, authenticationPoint, username, password);
            if (response.isOk()) {
                this.logLoggedInSuccessfully(username, client.getServerUrl(), logger);
            } else {
                logger.log(String.format("Login to ALM Server at %s failed. Status Code: %s", client.getServerUrl(), response.getStatusCode()));
                ret = false;
            }
        } else {
            logger.log("not authenticated");
        }
        return ret;
    }

    private Response login(Client client, String loginUrl, String username, String password) {
        byte[] credBytes = (username + ":" + password).getBytes();
        String credEncodedString = "Basic " + Base64Encoder.encode(credBytes);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", credEncodedString);
        return client.httpGet(loginUrl, null, headers, ResourceAccessLevel.PUBLIC);
    }

    public boolean logout(RestClient client, String username) {
        Response response = client.httpGet(client.build("authentication-point/logout"), null, null, ResourceAccessLevel.PUBLIC);
        return response.isOk();
    }

    public String isAuthenticated(Client client, Logger logger) {
        String ret;
        Response response = client.httpGet(client.build(IS_AUTHENTICATED), null, null, ResourceAccessLevel.PUBLIC);
        int responseCode = response.getStatusCode();
        if (responseCode == 200) {
            ret = null;
            this.logLoggedInSuccessfully(client.getUsername(), client.getServerUrl(), logger);
        } else if (responseCode == 401) {
            String newUrl = response.getHeaders().get(AUTHENTICATE_HEADER).get(0).split("=")[1];
            newUrl = newUrl.replace("\"", "");
            ret = newUrl = newUrl + "/authenticate";
        } else {
            try {
                throw response.getFailure();
            }
            catch (Throwable cause) {
                throw new SSEException(cause);
            }
        }
        return ret;
    }

    private void logLoggedInSuccessfully(String username, String loginServerUrl, Logger logger) {
        logger.log(String.format("Logged in successfully to ALM Server %s using %s", loginServerUrl, username));
    }
}

