/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk;

import com.adm.utils.uft.ALMRESTVersionUtils;
import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.model.ALMVersion;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.Response;
import com.adm.utils.uft.sdk.request.GetALMVersionRequest;

public class ALMRunReportUrlBuilder {
    public String build(Client client, String serverUrl, String domain, String project, String runId) {
        String ret = "NA";
        try {
            ret = this.isNewReport(client) ? String.format("%sui/?redirected&p=%s/%s&execution-report#/test-set-report/%s", serverUrl, domain, project, runId) : client.buildWebUIRequest(String.format("lab/index.jsp?processRunId=%s", runId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean isNewReport(Client client) {
        ALMVersion version = this.getALMVersion(client);
        return this.toInt(version.getMajorVersion()) >= 12 && this.toInt(version.getMinorVersion()) >= 2;
    }

    private int toInt(String str) {
        return Integer.parseInt(str);
    }

    private ALMVersion getALMVersion(Client client) {
        ALMVersion ret = null;
        Response response = new GetALMVersionRequest(client).execute();
        if (!response.isOk()) {
            throw new SSEException(String.format("Failed to get ALM version. HTTP status code: %d", response.getStatusCode()), response.getFailure());
        }
        ret = ALMRESTVersionUtils.toModel(response.getData());
        return ret;
    }
}

