/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.result;

import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.result.model.junit.Testsuites;
import com.adm.utils.uft.sdk.Logger;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ResultSerializer {
    private static final String FORMATTER_PATTERN = "ddMMyyyyHHmmssSSS";
    private static final String BAMBOO_BUILD_TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    private ResultSerializer() {
    }

    public static String saveResults(Testsuites testsuites, String workingDirectory, String buildTimeStamp, Logger logger) throws SSEException {
        String filePath = ResultSerializer.getFullFilePath(workingDirectory, ResultSerializer.getFileName(buildTimeStamp));
        try {
            if (testsuites != null) {
                StringWriter writer = new StringWriter();
                Marshaller marshaller = ResultSerializer.getJaxbContext(Testsuites.class).createMarshaller();
                marshaller.marshal((Object)testsuites, (Writer)writer);
                PrintWriter resultWriter = new PrintWriter(filePath);
                resultWriter.print(writer.toString());
                resultWriter.close();
                return filePath;
            }
            String message = "Empty Results";
            logger.log(message);
            throw new SSEException(message);
        }
        catch (Throwable cause) {
            String message = String.format("Failed to create run results, Exception: %s", cause.getMessage());
            logger.log(message);
            throw new SSEException(message);
        }
    }

    public static Testsuites Deserialize(File file) throws JAXBException {
        Unmarshaller jaxbUnmarshaller = ResultSerializer.getJaxbContext(Testsuites.class).createUnmarshaller();
        Testsuites testsuites = (Testsuites)jaxbUnmarshaller.unmarshal(file);
        return testsuites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext getJaxbContext(Class clazz) throws JAXBException {
        JAXBContext context;
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(ResultSerializer.class.getClassLoader());
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        finally {
            t.setContextClassLoader(orig);
        }
        return context;
    }

    private static String getFullFilePath(String workingDirectoryPath, String fileName) {
        return Paths.get(workingDirectoryPath, fileName).toString();
    }

    private static String getFileName(String buildTimeStamp) {
        SimpleDateFormat sourceDateFormat = new SimpleDateFormat(BAMBOO_BUILD_TIMESTAMP_PATTERN);
        try {
            Date buildDateTime = sourceDateFormat.parse(buildTimeStamp);
            SimpleDateFormat destDateFormat = new SimpleDateFormat(FORMATTER_PATTERN);
            buildTimeStamp = destDateFormat.format(buildDateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String resultsFileName = "Results" + buildTimeStamp + ".xml";
        return resultsFileName;
    }
}

