/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.model;

import com.adm.utils.uft.Aes256Encryptor;
import org.jetbrains.annotations.NotNull;

public class UftRunAsUser {
    private final Aes256Encryptor aes256Encryptor;
    private String username;
    private String encodedPassword;
    private String password;

    public UftRunAsUser(String username, String password, boolean isEncoded, @NotNull Aes256Encryptor aes256Encryptor) {
        this.username = username;
        if (isEncoded) {
            this.encodedPassword = password;
        } else {
            this.password = password;
        }
        this.aes256Encryptor = aes256Encryptor;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordAsEncrypted() throws Exception {
        return this.aes256Encryptor.Encrypt(this.password);
    }

    public String getEncodedPasswordAsEncrypted() throws Exception {
        return this.aes256Encryptor.Encrypt(this.encodedPassword);
    }
}

