/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.integration;

import com.adm.utils.uft.integration.HttpConnectionException;
import com.adm.utils.uft.integration.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class HttpUtils {
    public static final String POST = "POST";
    public static final String GET = "GET";

    private HttpUtils() {
    }

    public static HttpResponse post(ProxyInfo proxyInfo, String url, Map<String, String> headers, byte[] data) throws HttpConnectionException {
        HttpResponse response = null;
        try {
            response = HttpUtils.doHttp(proxyInfo, POST, url, null, headers, data);
        }
        catch (Exception e) {
            throw new HttpConnectionException();
        }
        return response;
    }

    public static HttpResponse get(ProxyInfo proxyInfo, String url, Map<String, String> headers, String queryString) throws HttpConnectionException {
        HttpResponse response = null;
        try {
            response = HttpUtils.doHttp(proxyInfo, GET, url, queryString, headers, null);
        }
        catch (Exception e) {
            throw new HttpConnectionException();
        }
        return response;
    }

    private static HttpResponse doHttp(ProxyInfo proxyInfo, String requestMethod, String connectionUrl, String queryString, Map<String, String> headers, byte[] data) throws IOException {
        HttpResponse response = new HttpResponse();
        if (queryString != null && !queryString.isEmpty()) {
            connectionUrl = connectionUrl + "?" + queryString;
        }
        URL url = new URL(connectionUrl);
        HttpURLConnection connection = (HttpURLConnection)HttpUtils.openConnection(proxyInfo, url);
        connection.setRequestMethod(requestMethod);
        HttpUtils.setConnectionHeaders(connection, headers);
        if (data != null && data.length > 0) {
            connection.setDoOutput(true);
            try {
                OutputStream out = connection.getOutputStream();
                out.write(data);
                out.flush();
                out.close();
            }
            catch (Throwable cause) {
                cause.printStackTrace();
            }
        }
        connection.connect();
        int resCode = connection.getResponseCode();
        response.setResponseCode(resCode);
        response.setResponseMessage(connection.getResponseMessage());
        if (resCode == 200 || resCode == 201 || resCode == 202) {
            InputStream inputStream = connection.getInputStream();
            JSONObject jsonObject = HttpUtils.convertStreamToJSONObject(inputStream);
            Map<String, List<String>> headerFields = connection.getHeaderFields();
            response.setHeaders(headerFields);
            response.setJsonObject(jsonObject);
        }
        connection.disconnect();
        return response;
    }

    private static URLConnection openConnection(final ProxyInfo proxyInfo, URL _url) throws IOException {
        Proxy proxy = null;
        if (proxyInfo != null && proxyInfo._host != null && proxyInfo._port != null && !proxyInfo._host.isEmpty() && !proxyInfo._port.isEmpty()) {
            try {
                int port = Integer.parseInt(proxyInfo._port.trim());
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo._host, port));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (proxy != null && proxyInfo._userName != null && proxyInfo._password != null && !proxyInfo._password.isEmpty() && !proxyInfo._password.isEmpty()) {
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo._userName, proxyInfo._password.toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
        }
        if (proxy == null) {
            return _url.openConnection();
        }
        return _url.openConnection(proxy);
    }

    private static void setConnectionHeaders(HttpURLConnection connection, Map<String, String> headers) {
        if (connection != null && headers != null && headers.size() != 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
    }

    private static JSONObject convertStreamToJSONObject(InputStream inputStream) {
        JSONObject obj = null;
        if (inputStream != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer res = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    res.append(line);
                }
                obj = (JSONObject)JSONValue.parseStrict(res.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static ProxyInfo setProxyCfg(String host, String port, String userName, String password) {
        return new ProxyInfo(host, port, userName, password);
    }

    public static ProxyInfo setProxyCfg(String host, String port) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo._host = host;
        proxyInfo._port = port;
        return proxyInfo;
    }

    public static ProxyInfo setProxyCfg(String address, String userName, String password) {
        ProxyInfo proxyInfo = new ProxyInfo();
        if (address != null) {
            int i;
            if (address.endsWith("/")) {
                int end = address.lastIndexOf("/");
                address = address.substring(0, end);
            }
            if ((i = address.lastIndexOf(58)) > 0) {
                proxyInfo._host = address.substring(0, i);
                proxyInfo._port = address.substring(i + 1, address.length());
            } else {
                proxyInfo._host = address;
                proxyInfo._port = "80";
            }
            proxyInfo._userName = userName;
            proxyInfo._password = password;
        }
        return proxyInfo;
    }

    static class ProxyInfo {
        private String _host;
        private String _port;
        private String _userName;
        private String _password;

        public ProxyInfo() {
        }

        public ProxyInfo(String host, String port, String userName, String password) {
            this._host = host;
            this._port = port;
            this._userName = userName;
            this._password = password;
        }
    }
}

