/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft;

import com.adm.bamboo.plugin.uft.results.ResultInfoItem;
import com.adm.utils.uft.TaskUtils;
import com.adm.utils.uft.enums.UFTConstants;
import com.adm.utils.uft.sdk.DirectoryZipHelper;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public final class FilesHandler {
    private static final String HpToolsLauncher_SCRIPT_NAME = "HpToolsLauncher.exe";
    private static final String HpToolsAborter_SCRIPT_NAME = "HpToolsAborter.exe";
    private static final String HP_UFT_PREFIX = "UFT_Build_";
    private static final String FORMATTER_PATTERN = "ddMMyyyyHHmmssSSS";
    private static final String BAMBOO_BUILD_TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    private FilesHandler() {
    }

    public static void zipResult(ResultInfoItem resultItem, BuildLogger logger) {
        try {
            DirectoryZipHelper.zipFolder(resultItem.getSourceDir().getPath(), resultItem.getZipFile().getPath());
        }
        catch (Exception ex) {
            logger.addBuildLogEntry(ex.getMessage());
        }
    }

    public static File buildPropertiesFile(TaskContext taskContext, File workingDirectory, Properties mergedProperties, String buildTimeStamp, BuildLogger buildLogger) {
        SimpleDateFormat sourceDateFormat = new SimpleDateFormat(BAMBOO_BUILD_TIMESTAMP_PATTERN);
        try {
            Date buildDateTime = sourceDateFormat.parse(buildTimeStamp);
            SimpleDateFormat destDateFormat = new SimpleDateFormat(FORMATTER_PATTERN);
            buildTimeStamp = destDateFormat.format(buildDateTime);
        }
        catch (ParseException e) {
            buildLogger.addBuildLogEntry("Unable to parse object");
            e.printStackTrace();
        }
        String paramFileName = "props" + buildTimeStamp + ".txt";
        String resultsFileName = "Results" + buildTimeStamp + ".xml";
        mergedProperties.put("resultsFilename", resultsFileName);
        File resultFile = new File(workingDirectory, resultsFileName);
        File paramsFile = new File(workingDirectory, paramFileName);
        if (paramsFile.exists()) {
            paramsFile.delete();
        }
        try {
            paramsFile.createNewFile();
            FileOutputStream outputFile = new FileOutputStream(paramsFile);
            mergedProperties.store(outputFile, "");
            outputFile.close();
        }
        catch (Exception e) {
            TaskUtils.logErrorMessage(e, buildLogger, taskContext);
        }
        return paramsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractBinaryResource(InputStream stream, File pathToExtract, String resourceName) throws IOException {
        OutputStream resStreamOut = null;
        String resourcePath = UFTConstants.TOOLS_PATH.getValue() + "/" + resourceName;
        try {
            Integer readBytes;
            if (stream == null) {
                String string = "Cannot get resource \"" + resourcePath + "\" from Jar file.";
                return string;
            }
            byte[] buffer = new byte[4096];
            resStreamOut = new FileOutputStream(new File(pathToExtract, resourceName));
            while ((readBytes = Integer.valueOf(stream.read(buffer))) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
                resStreamOut.close();
            }
        }
        return "";
    }

    public static String getToolPath(TaskContext taskContext, File workingDirectory, Boolean useLauncherTool) throws IOException {
        String toolScriptName = HpToolsLauncher_SCRIPT_NAME;
        if (!useLauncherTool.booleanValue()) {
            toolScriptName = HpToolsAborter_SCRIPT_NAME;
        }
        String toolPath = new File(workingDirectory, toolScriptName).getAbsolutePath();
        String resourcePath = UFTConstants.TOOLS_PATH.getValue() + "/" + toolScriptName;
        FilesHandler.copyResource(taskContext, workingDirectory, resourcePath, toolScriptName);
        return toolPath;
    }

    public static TaskResult copyResource(TaskContext taskContext, File workingDirectory, String resourcePath, String resourceName) throws IOException {
        TaskResult result = null;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        InputStream resourceStream = FilesHandler.class.getClassLoader().getResourceAsStream(resourcePath);
        String error = FilesHandler.extractBinaryResource(resourceStream, workingDirectory, resourceName);
        if (!error.isEmpty()) {
            buildLogger.addErrorLogEntry(error);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return result;
    }

    public static String getOutputFilePath(TaskContext taskContext) {
        StringBuilder fileName = new StringBuilder(taskContext.getWorkingDirectory().toString());
        String taskName = (String)taskContext.getConfigurationMap().get((Object)UFTConstants.TASK_NAME.getValue());
        fileName.append("\\").append(HP_UFT_PREFIX).append(taskContext.getBuildContext().getBuildNumber()).append("\\").append(String.format("%03d", taskContext.getId())).append("_").append(taskName).append("\\");
        return fileName.toString();
    }

    public static boolean isMtbxContent(String testContent) {
        return StringUtils.isNotEmpty(testContent) && testContent.toLowerCase().contains("<mtbx>");
    }

    public static String saveMtbxContent(TaskContext taskContext, String mtbxContent) {
        String testsFileName = "tests_build_" + taskContext.getBuildContext().getResultKey().getResultNumber() + ".mtbx";
        try {
            File testFile = new File(taskContext.getWorkingDirectory(), testsFileName);
            FileUtils.writeStringToFile(testFile, mtbxContent);
            return testFile.getPath();
        }
        catch (IOException e) {
            TaskUtils.logErrorMessage("Failed to save mtbx file : " + e.getMessage(), taskContext.getBuildLogger(), taskContext);
            return "";
        }
    }
}

