/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.task;

import com.adm.bamboo.plugin.uft.api.AbstractLauncherTask;
import com.adm.bamboo.plugin.uft.helpers.LauncherParamsBuilder;
import com.adm.bamboo.plugin.uft.helpers.locator.UFTLocatorService;
import com.adm.bamboo.plugin.uft.helpers.locator.UFTLocatorServiceFactory;
import com.adm.bamboo.plugin.uft.results.ResultInfoItem;
import com.adm.bamboo.plugin.uft.results.TestResultHelper;
import com.adm.bamboo.plugin.uft.results.TestResultHelperFileSystem;
import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.FilesHandler;
import com.adm.utils.uft.enums.ResultTypeFilter;
import com.adm.utils.uft.enums.RunType;
import com.adm.utils.uft.enums.UFTConstants;
import com.adm.utils.uft.integration.HttpConnectionException;
import com.adm.utils.uft.integration.JobOperation;
import com.amazonaws.util.StringUtils;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class RunFromFileSystemUftTask
implements AbstractLauncherTask {
    private final I18nBean i18nBean;
    private final TestCollationService testCollationService;
    private final CustomVariableContext customVariableContext;
    private final CapabilityContext capabilityContext;
    private final Aes256Encryptor aes256Encryptor;

    public RunFromFileSystemUftTask(@NotNull TestCollationService testCollationService, CapabilityContext capabilityContext, @NotNull I18nBeanFactory i18nBeanFactory, @ComponentImport CustomVariableContext customVariableContext) {
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.testCollationService = testCollationService;
        this.customVariableContext = customVariableContext;
        this.capabilityContext = capabilityContext;
        this.aes256Encryptor = new Aes256Encryptor(this.getEncryptionKeyVectorPair());
    }

    @Override
    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    @Override
    public Aes256Encryptor getAes256Encryptor() {
        return this.aes256Encryptor;
    }

    @Override
    public Properties getTaskProperties(TaskContext taskContext) {
        String[] testNames;
        String tests;
        String splitMarker = "\n";
        ConfigurationMap map = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        LauncherParamsBuilder builder = new LauncherParamsBuilder(this.aes256Encryptor);
        builder.setRunType(RunType.FILE_SYSTEM);
        String timeout = (String)map.get((Object)UFTConstants.TIMEOUT.getValue());
        builder.setFsTimeout(timeout);
        boolean useMC = BooleanUtils.toBoolean((String)map.get((Object)UFTConstants.USE_MC_SETTINGS.getValue()));
        if (useMC) {
            this.addMobileCenterSettings(builder, map, buildLogger);
        }
        if (FilesHandler.isMtbxContent(tests = (String)map.get((Object)UFTConstants.TESTS_PATH.getValue()))) {
            String filePath = FilesHandler.saveMtbxContent(taskContext, tests);
            testNames = new String[]{filePath};
        } else {
            testNames = tests == null ? new String[]{} : tests.split("\n");
        }
        for (int i = 0; i < testNames.length; ++i) {
            builder.setTest(i + 1, testNames[i]);
        }
        return builder.getProperties();
    }

    private void addMobileCenterSettings(LauncherParamsBuilder builder, ConfigurationMap map, BuildLogger buildLogger) {
        boolean useProxy;
        String proxyAddress = null;
        String proxyUserName = null;
        String proxyPassword = null;
        String mcServerUrl = (String)map.get((Object)UFTConstants.MC_SERVER_URL.getValue());
        String mcUserName = (String)map.get((Object)UFTConstants.MC_USERNAME.getValue());
        String mcPassword = (String)map.get((Object)UFTConstants.MC_PASSWORD.getValue());
        boolean useSSL = BooleanUtils.toBoolean((String)map.get((Object)UFTConstants.USE_SSL.getValue()));
        builder.setMobileUseSSL(useSSL ? 1 : 0);
        if (useSSL) {
            buildLogger.addBuildLogEntry("********** Use SSL ********** ");
        }
        builder.setMobileUseProxy((useProxy = BooleanUtils.toBoolean((String)map.get((Object)UFTConstants.USE_PROXY.getValue()))) ? 1 : 0);
        if (useProxy) {
            Boolean specifyAuthentication;
            buildLogger.addBuildLogEntry("********** Use Proxy ********** ");
            builder.setMobileProxyType(2);
            proxyAddress = (String)map.get((Object)UFTConstants.PROXY_ADDRESS.getValue());
            if (proxyAddress != null) {
                builder.setMobileProxySetting_Address(proxyAddress);
            }
            builder.setMobileProxySetting_Authentication((specifyAuthentication = Boolean.valueOf(BooleanUtils.toBoolean(UFTConstants.SPECIFY_AUTHENTICATION.getValue()))) != false ? 1 : 0);
            if (specifyAuthentication.booleanValue()) {
                proxyUserName = (String)map.get((Object)UFTConstants.PROXY_USERNAME.getValue());
                proxyPassword = (String)map.get((Object)UFTConstants.PROXY_PASSWORD.getValue());
                if (proxyUserName != null && proxyPassword != null) {
                    builder.setMobileProxySetting_UserName(proxyUserName);
                    builder.setMobileProxySetting_Password(proxyPassword);
                }
            }
        } else {
            builder.setMobileProxyType(0);
        }
        if (!this.mcInfoCheck(mcServerUrl, mcUserName, mcPassword)) {
            builder.setServerUrl(mcServerUrl);
            builder.setUserName(mcUserName);
            builder.setFileSystemPassword(mcPassword);
            JobOperation operation = new JobOperation(mcServerUrl, mcUserName, mcPassword, proxyAddress, proxyUserName, proxyPassword);
            builder.setMobileInfo(this.addMCJobInfoToTaskProperties(operation, map, buildLogger));
        }
    }

    private String addMCJobInfoToTaskProperties(JobOperation operation, ConfigurationMap map, BuildLogger buildLogger) {
        String mobileInfo = null;
        String jobUUID = (String)map.get((Object)UFTConstants.JOB_UUID.getValue());
        if (jobUUID != null) {
            JSONObject jobJSON = null;
            try {
                jobJSON = operation.getJobById(jobUUID);
            }
            catch (HttpConnectionException e) {
                buildLogger.addErrorLogEntry("********** Failed to connect Functional Testing Lab, please check URL, UserName / Password, and Proxy Configuration ********** ");
            }
            if (jobJSON != null) {
                JSONObject dataJSON = (JSONObject)jobJSON.get("data");
                if (dataJSON != null) {
                    JSONArray extArr;
                    JSONObject applicationJSONObject = (JSONObject)dataJSON.get("application");
                    if (applicationJSONObject != null) {
                        applicationJSONObject.remove(UFTConstants.ICON.getValue());
                    }
                    if ((extArr = (JSONArray)dataJSON.get("extraApps")) != null) {
                        for (JSONObject extAppJSONObject : extArr) {
                            extAppJSONObject.remove(UFTConstants.ICON.getValue());
                        }
                    }
                }
                mobileInfo = dataJSON.toJSONString();
            }
        }
        return mobileInfo;
    }

    @Override
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        String fullPathOfUftExe = this.capabilityContext.getCapabilityValue("system.builder.OpenText.Functional Testing");
        UFTLocatorService locator = UFTLocatorServiceFactory.getInstance().getLocator();
        if (!locator.validateUFTPath(fullPathOfUftExe)) {
            taskContext.getBuildLogger().addErrorLogEntry(this.i18nBean.getText("MFCapability.notValid"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return AbstractLauncherTask.super.execute(taskContext);
    }

    @Override
    public TaskResult collateResults(@NotNull TaskContext taskContext, Properties mergedProperties) {
        try {
            TestResultHelper.collateTestResults(this.testCollationService, taskContext);
            this.prepareArtifacts(taskContext, mergedProperties);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().build();
        }
        catch (Exception ex) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
    }

    private void prepareArtifacts(TaskContext taskContext, Properties mergedProperties) {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        File resultFile = new File(taskContext.getWorkingDirectory(), mergedProperties.get("resultsFilename").toString());
        ResultTypeFilter resultsFilter = this.getResultTypeFilter(taskContext);
        if (resultsFilter == null) {
            return;
        }
        String resultNameFormat = this.i18nBean.getText(UFTConstants.ARTIFACT_NAME_FORMAT.getValue());
        Collection<ResultInfoItem> resultsPaths = TestResultHelperFileSystem.getTestResults(resultFile, resultsFilter, resultNameFormat, taskContext, buildLogger);
        for (ResultInfoItem resultItem : resultsPaths) {
            String dir = resultItem.getSourceDir().getPath();
            File fileReport = new File(dir, UFTConstants.RESULT_HTML_REPORT_FILE_NAME.getValue());
            if (fileReport.exists()) {
                this.prepareHtmlArtifact(resultItem, taskContext, buildLogger);
                continue;
            }
            FilesHandler.zipResult(resultItem, buildLogger);
        }
        for (ResultInfoItem resultItem : resultsPaths) {
            FilesHandler.zipResult(resultItem, buildLogger);
        }
    }

    private void prepareHtmlArtifact(ResultInfoItem resultItem, TaskContext taskContext, BuildLogger logger) {
        File contentDir = resultItem.getSourceDir();
        if (contentDir == null || !contentDir.isDirectory()) {
            return;
        }
        File destPath = new File(FilesHandler.getOutputFilePath(taskContext), resultItem.getTestName());
        if (!destPath.exists() && !destPath.isDirectory()) {
            destPath.mkdirs();
        }
        try {
            FileUtils.copyDirectoryToDirectory(contentDir, destPath);
        }
        catch (Exception e) {
            logger.addBuildLogEntry(e.getMessage());
            return;
        }
        String content = this.getContent(contentDir.getName(), UFTConstants.RESULT_HTML_REPORT_FILE_NAME.getValue(), UFTConstants.HTML_REPORT_FILE_NAME.getValue());
        try {
            FileUtils.writeStringToFile(new File(destPath, UFTConstants.HTML_REPORT_FILE_NAME.getValue()), content);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ResultTypeFilter getResultTypeFilter(TaskContext taskContext) {
        String publishMode = (String)taskContext.getConfigurationMap().get((Object)UFTConstants.PUBLISH_MODE_PARAM.getValue());
        if (publishMode.equals(UFTConstants.PUBLISH_MODE_FAILED_VALUE.getValue())) {
            return ResultTypeFilter.FAILED;
        }
        if (publishMode.equals(UFTConstants.PUBLISH_MODE_NEVER_VALUE.getValue())) {
            return null;
        }
        return ResultTypeFilter.All;
    }

    private boolean mcInfoCheck(String mcUrl, String mcUserName, String mcPassword) {
        return StringUtils.isNullOrEmpty((String)mcUrl) || StringUtils.isNullOrEmpty((String)mcUserName) || StringUtils.isNullOrEmpty((String)mcPassword);
    }

    private String getContent(String contentDirectoryName, String resultFileName, String reportFileName) {
        String content = "<!DOCTYPE html>\n<html>\n    <head>\n        <title>Test</title>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n        <script type=\"text/javascript\">\n        function codeAddress() {\n\t\t \tvar currentUrl = window.location.toString();\n\t\t\tvar replaceString = '" + contentDirectoryName + "/" + resultFileName + "';\n\t\t \tcurrentUrl = currentUrl.replace('" + reportFileName + "', replaceString);\n        \twindow.location = currentUrl;\n        }\n        window.onload = codeAddress;\n        </script>\n    </head>\n    <body>\n   \n    </body>\n</html>";
        return content;
    }
}

