/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.task;

import com.adm.bamboo.plugin.uft.api.AbstractLauncherTask;
import com.adm.bamboo.plugin.uft.helpers.LauncherParamsBuilder;
import com.adm.bamboo.plugin.uft.helpers.locator.UFTLocatorServiceFactory;
import com.adm.bamboo.plugin.uft.results.TestResultHelper;
import com.adm.bamboo.plugin.uft.results.TestResultHelperAlm;
import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.enums.AlmRunMode;
import com.adm.utils.uft.enums.RunType;
import com.adm.utils.uft.enums.UFTConstants;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RunFromAlmUftTask
implements AbstractLauncherTask {
    private final I18nBean i18nBean;
    private final TestCollationService testCollationService;
    private final CustomVariableContext customVariableContext;
    private final CapabilityContext capabilityContext;
    private final Aes256Encryptor aes256Encryptor;

    public RunFromAlmUftTask(TestCollationService testCollationService, CapabilityContext capabilityContext, @NotNull I18nBeanFactory i18nBeanFactory, @ComponentImport CustomVariableContext customVariableContext) {
        this.i18nBean = i18nBeanFactory.getI18nBean();
        this.testCollationService = testCollationService;
        this.customVariableContext = customVariableContext;
        this.capabilityContext = capabilityContext;
        this.aes256Encryptor = new Aes256Encryptor(this.getEncryptionKeyVectorPair());
    }

    @Override
    public Aes256Encryptor getAes256Encryptor() {
        return this.aes256Encryptor;
    }

    @Override
    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    @Override
    public Properties getTaskProperties(TaskContext taskContext) {
        String splitMarker = "\n";
        ConfigurationMap map = taskContext.getConfigurationMap();
        LauncherParamsBuilder builder = new LauncherParamsBuilder(this.getAes256Encryptor());
        builder.setRunType(RunType.ALM);
        String almServerPath = (String)map.get((Object)UFTConstants.ALM_SERVER.getValue());
        builder.setAlmServerUrl(almServerPath);
        builder.setAlmSSO((String)map.get((Object)UFTConstants.ALM_SSO.getValue()));
        if (Boolean.valueOf((String)map.get((Object)UFTConstants.ALM_SSO.getValue())).equals(true)) {
            builder.setAlmClientID((String)map.get((Object)UFTConstants.CLIENT_ID.getValue()));
            builder.setAlmApiKeySecret((String)map.get((Object)UFTConstants.API_KEY_SECRET.getValue()));
            builder.setAlmUserName("");
            builder.setAlmPassword("");
        } else {
            builder.setAlmUserName((String)map.get((Object)UFTConstants.USER_NAME.getValue()));
            builder.setAlmPassword((String)map.get((Object)UFTConstants.PASSWORD.getValue()));
        }
        builder.setAlmDomain((String)map.get((Object)UFTConstants.DOMAIN.getValue()));
        builder.setAlmProject((String)map.get((Object)UFTConstants.PROJECT.getValue()));
        String runMode = (String)map.get((Object)UFTConstants.RUN_MODE.getValue());
        if (runMode.equals(UFTConstants.RUN_LOCALLY_PARAMETER.getValue())) {
            builder.setAlmRunMode(AlmRunMode.RUN_LOCAL);
        } else if (runMode.equals(UFTConstants.RUN_ON_PLANNED_HOST_PARAMETER.getValue())) {
            builder.setAlmRunMode(AlmRunMode.RUN_PLANNED_HOST);
        } else if (runMode.equals(UFTConstants.RUN_REMOTELY_PARAMETER.getValue())) {
            builder.setAlmRunMode(AlmRunMode.RUN_REMOTE);
        }
        builder.setAlmRunHost((String)map.get((Object)UFTConstants.TESTING_TOOL_HOST.getValue()));
        String timeout = (String)map.get((Object)UFTConstants.TIMEOUT.getValue());
        if (StringUtils.isEmpty(timeout)) {
            builder.setAlmTimeout(UFTConstants.DEFAULT_TIMEOUT.getValue());
        } else {
            builder.setAlmTimeout(timeout);
        }
        String almTestSets = (String)map.get((Object)UFTConstants.TESTS_PATH.getValue());
        if (!StringUtils.isEmpty(almTestSets)) {
            String[] testSetsArr = almTestSets.replaceAll("\r", "").split("\n");
            int index = 1;
            for (String testSet : testSetsArr) {
                builder.setTestSet(index, testSet);
                ++index;
            }
        } else {
            builder.setAlmTestSet("");
        }
        return builder.getProperties();
    }

    @Override
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        ConfigurationMap map = taskContext.getConfigurationMap();
        String runMode = (String)map.get((Object)UFTConstants.RUN_MODE.getValue());
        if (runMode.equals(UFTConstants.RUN_LOCALLY_PARAMETER.getValue()) && !UFTLocatorServiceFactory.getInstance().getLocator().validateUFTPath(this.capabilityContext.getCapabilityValue("system.builder.OpenText.Functional Testing"))) {
            taskContext.getBuildLogger().addErrorLogEntry(this.i18nBean.getText("MFCapability.notValid"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failedWithError().build();
        }
        return AbstractLauncherTask.super.execute(taskContext);
    }

    @Override
    public TaskResult collateResults(@NotNull TaskContext taskContext, Properties mergedProperties) {
        try {
            TestResultHelper.collateTestResults(this.testCollationService, taskContext);
            File resultFile = new File(taskContext.getWorkingDirectory(), mergedProperties.get("resultsFilename").toString());
            TestResultHelperAlm.AddALMArtifacts(taskContext, resultFile, UFTConstants.LINK_SEARCH_FILTER.getValue(), this.i18nBean);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().build();
        }
        catch (Exception ex) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
    }
}

