/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.task;

import com.adm.bamboo.plugin.uft.api.AbstractLauncherTask;
import com.adm.bamboo.plugin.uft.results.TestResultHelper;
import com.adm.bamboo.plugin.uft.results.TestResultHelperAlm;
import com.adm.utils.uft.Aes256Encryptor;
import com.adm.utils.uft.SSEException;
import com.adm.utils.uft.enums.UFTConstants;
import com.adm.utils.uft.model.CdaDetails;
import com.adm.utils.uft.rest.RestClient;
import com.adm.utils.uft.result.ResultSerializer;
import com.adm.utils.uft.result.model.junit.Testsuites;
import com.adm.utils.uft.sdk.Args;
import com.adm.utils.uft.sdk.Logger;
import com.adm.utils.uft.sdk.RunManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class RunFromAlmLabManagementUftTask
implements AbstractLauncherTask {
    private final TestCollationService testCollationService;
    private static I18nBean i18nBean;
    private final CustomVariableContext customVariableContext;
    private final String LINK_SEARCH_FILTER = "run report for run id";

    public RunFromAlmLabManagementUftTask(TestCollationService testCollationService, @NotNull I18nBeanFactory i18nBeanFactory, @ComponentImport CustomVariableContext customVariableContext) {
        this.testCollationService = testCollationService;
        i18nBean = i18nBeanFactory.getI18nBean();
        this.customVariableContext = customVariableContext;
    }

    @Override
    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    @Override
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        final BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap map = taskContext.getConfigurationMap();
        String almServerPath = (String)map.get((Object)UFTConstants.ALM_SERVER.getValue());
        RunManager runManager = new RunManager();
        CdaDetails cdaDetails = null;
        boolean useCda = BooleanUtils.toBoolean((String)map.get((Object)UFTConstants.USE_SDA_PARAM.getValue()));
        if (useCda) {
            cdaDetails = new CdaDetails((String)map.get((Object)UFTConstants.DEPLOYMENT_ACTION_PARAM.getValue()), (String)map.get((Object)UFTConstants.DEPLOYED_ENVIRONMENT_NAME.getValue()), (String)map.get((Object)UFTConstants.DEPROVISIONING_ACTION_PARAM.getValue()));
        }
        Args args = new Args(almServerPath, (String)map.get((Object)UFTConstants.ALM_SSO.getValue()), (String)map.get((Object)UFTConstants.CLIENT_ID.getValue()), (String)map.get((Object)UFTConstants.API_KEY_SECRET.getValue()), (String)map.get((Object)UFTConstants.DOMAIN_PARAM.getValue()), (String)map.get((Object)UFTConstants.PROJECT_NAME_PARAM.getValue()), (String)map.get((Object)UFTConstants.USER_NAME.getValue()), (String)map.get((Object)UFTConstants.PASSWORD.getValue()), (String)map.get((Object)UFTConstants.RUN_TYPE_PARAM.getValue()), (String)map.get((Object)UFTConstants.TEST_ID_PARAM.getValue()), (String)map.get((Object)UFTConstants.DURATION_PARAM.getValue()), (String)map.get((Object)UFTConstants.DESCRIPTION_PARAM.getValue()), null, (String)map.get((Object)UFTConstants.ENVIRONMENT_ID_PARAM.getValue()), cdaDetails);
        RestClient restClient = new RestClient(args.getUrl(), args.getDomain(), args.getProject(), args.getUsername());
        try {
            Logger logger = new Logger(){

                @Override
                public void log(String message) {
                    buildLogger.addBuildLogEntry(message);
                }
            };
            Testsuites result = runManager.execute(restClient, args, logger);
            taskContext.getBuildLogger().addBuildLogEntry("Bamboo build timestamp variable has value: " + this.getBuildTimeStamp());
            ResultSerializer.saveResults(result, taskContext.getWorkingDirectory().getPath(), this.getBuildTimeStamp(), logger);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        catch (SSEException e) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        return this.collateResults(taskContext, null);
    }

    @Override
    public Properties getTaskProperties(TaskContext taskContext) {
        return null;
    }

    @Override
    public TaskResult collateResults(@NotNull TaskContext taskContext, Properties mergedProperties) {
        try {
            TestResultHelper.collateTestResults(this.testCollationService, taskContext);
            TestResultHelperAlm.AddALMArtifacts(taskContext, null, "run report for run id", i18nBean);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().build();
        }
        catch (Exception ex) {
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
    }

    @Override
    public Aes256Encryptor getAes256Encryptor() {
        return null;
    }
}

