/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.helpers.locator.windows;

import com.adm.bamboo.plugin.uft.helpers.WindowsRegistry;
import com.adm.bamboo.plugin.uft.helpers.locator.UFTLocatorService;
import com.adm.utils.uft.StringUtils;
import java.io.File;

public class WindowsUFTLocatorService
implements UFTLocatorService {
    private static final String UFT_REGISTRY_KEY = "SOFTWARE\\Mercury Interactive\\QuickTest Professional\\CurrentVersion";
    private static final String UFT_REGISTRY_INSTALL_VALUE = "QuickTest Professional";
    private static final String UFT_REGISTRY_VERSION_MAJOR_VALUE = "Major";
    private static final String UFT_EXE_NAME = "bin\\UFT.exe";

    @Override
    public boolean isInstalled() {
        return !StringUtils.isBlank(WindowsRegistry.readHKLMString(UFT_REGISTRY_KEY, UFT_REGISTRY_VERSION_MAJOR_VALUE));
    }

    @Override
    public String getUftExeFullPath() {
        String installPath = WindowsRegistry.readHKLMString(UFT_REGISTRY_KEY, UFT_REGISTRY_INSTALL_VALUE);
        if (StringUtils.isBlank(installPath)) {
            return "";
        }
        File f = new File(installPath);
        if (f.exists() && f.isDirectory() && (f = new File(f, UFT_EXE_NAME)).exists() && f.isFile()) {
            return f.getAbsolutePath();
        }
        return "";
    }

    @Override
    public String getPathFromManualPoint(String startingPathPoint) {
        return startingPathPoint + "\\" + UFT_EXE_NAME;
    }

    @Override
    public boolean validateUFTPath(String path) {
        File f = new File(path);
        String fullPathOfUftExe = this.getUftExeFullPath();
        return f.exists() && f.isFile() && fullPathOfUftExe.equalsIgnoreCase(f.getAbsolutePath());
    }
}

