/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.helpers;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;

public class WindowsRegistry {
    private static final String SOFTWARE_KEY = "SOFTWARE\\";
    private static final String WOW_6432_PREFIX = "SOFTWARE\\WOW6432NODE\\";

    private static boolean IsX64() {
        String arch = System.getProperty("os.arch");
        if (arch == null) {
            return false;
        }
        return arch.contains("64");
    }

    private static String GetArchKeyName(String key) {
        String keyUpper = key.toUpperCase();
        if (WindowsRegistry.IsX64() && !keyUpper.startsWith(WOW_6432_PREFIX) && keyUpper.startsWith(SOFTWARE_KEY)) {
            return WOW_6432_PREFIX + key.substring(SOFTWARE_KEY.length());
        }
        return key;
    }

    public static String readHKLMString(String key, String value) {
        try {
            String newKey = WindowsRegistry.GetArchKeyName(key);
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)newKey, (String)value);
        }
        catch (Throwable e) {
            return "";
        }
    }
}

