/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.uft.capability;

import com.adm.bamboo.plugin.uft.helpers.locator.UFTLocatorService;
import com.adm.bamboo.plugin.uft.helpers.locator.UFTLocatorServiceFactory;
import com.adm.utils.uft.StringUtils;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractExecutableCapabilityTypeModule;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UftCapabilityTypeModule
extends AbstractExecutableCapabilityTypeModule {
    public static final String MF_PREFIX = "system.builder.OpenText";
    public static final String MF_UFT_CAPABILITY = "system.builder.OpenText.Functional Testing";
    public static final String UFT_EXECUTABLE = "uft";
    public static final String UFT_EXECUTABLE_KEY = "uftPath";
    private static final String FIELD_UFT_PATH = "uftPath";
    private static final String FIELD_UFT_DETECTION = "uftDetection";
    private static final String CAPABILITY_TYPE_ERROR_UNDEFINED_EXECUTABLE = "agent.capability.type.system.builder.OpenText.undefinedExecutable";
    private final UFTLocatorService locatorService = UFTLocatorServiceFactory.getInstance().getLocator();

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        if (this.locatorService.isInstalled()) {
            String uftPath = this.locatorService.getUftExeFullPath();
            if (!uftPath.isEmpty()) {
                capabilitySet.addCapability((Capability)new CapabilityImpl(MF_UFT_CAPABILITY, uftPath));
                return capabilitySet;
            }
            capabilitySet.removeCapability(MF_UFT_CAPABILITY);
        }
        return capabilitySet;
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        boolean detectionFlag = !StringUtils.isNullOrEmpty(UftCapabilityTypeModule.getParamValue(params, (String)FIELD_UFT_DETECTION));
        HashMap<String, String> errors = new HashMap<String, String>();
        if (detectionFlag) {
            String givenPath = UftCapabilityTypeModule.getParamValue(params, (String)"uftPath");
            if (StringUtils.isNullOrEmpty(givenPath)) {
                errors.put("uftPath", this.getText("MFCapability.unspecifiedPath"));
                return errors;
            }
            if (givenPath.contains(".")) {
                errors.put("uftPath", this.getText("MFCapability.executableErr"));
            }
        } else if (!this.locatorService.isInstalled()) {
            errors.put(FIELD_UFT_DETECTION, this.getText("MFCapability.notInstalled"));
        }
        return errors;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        boolean detectionFlag = !StringUtils.isNullOrEmpty(UftCapabilityTypeModule.getParamValue(params, (String)FIELD_UFT_DETECTION));
        String uftPath = detectionFlag ? this.locatorService.getPathFromManualPoint(UftCapabilityTypeModule.getParamValue(params, (String)"uftPath")) : this.locatorService.getUftExeFullPath();
        return new CapabilityImpl(MF_UFT_CAPABILITY, uftPath);
    }

    public String getMandatoryCapabilityKey() {
        return MF_UFT_CAPABILITY;
    }

    public String getExecutableKey() {
        return "uftPath";
    }

    public String getCapabilityUndefinedKey() {
        return CAPABILITY_TYPE_ERROR_UNDEFINED_EXECUTABLE;
    }

    public List<String> getDefaultWindowPaths() {
        return Lists.newArrayList();
    }

    public String getExecutableFilename() {
        return UFT_EXECUTABLE;
    }

    public String getExecutableDescription() {
        return this.getText("MFCapability.descExec");
    }

    public String getDetectionDescription() {
        return this.getText("MFCapability.descDetection");
    }
}

