/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.ui;

import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import java.util.LinkedHashMap;
import java.util.Map;

public class SVExportTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Map SERVICE_SELECTION = new LinkedHashMap();

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("url", params.getString("url"));
        config.put("userName", params.getString("userName"));
        config.put("password", params.getString("password"));
        config.put("serviceSelection", params.getString("serviceSelection"));
        config.put("serviceNameOrId", params.getString("serviceNameOrId"));
        config.put("projectPath", params.getString("projectPath"));
        config.put("projectPassword", params.getString("projectPassword"));
        config.put("targetDirectory", params.getString("targetDirectory"));
        config.put("cleanTargetDirectory", params.getString("cleanTargetDirectory"));
        config.put("switchServiceToStandBy", params.getString("switchServiceToStandBy"));
        config.put("force", params.getString("force"));
        config.put("archive", params.getString("archive"));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String projectPathValue;
        String targetDirectoryValue;
        super.validate(params, errorCollection);
        String urlValue = params.getString("url");
        if (!SVExecutorUtil.validInput(urlValue)) {
            errorCollection.addError("url", "Error: Management Endpoint URL cannot be empty");
        }
        if (!SVExecutorUtil.validInput(targetDirectoryValue = params.getString("targetDirectory"))) {
            errorCollection.addError("targetDirectory", "Error: Target directory cannot be empty");
        }
        if ("SERVICE".equals(params.getString("serviceSelection"))) {
            String serviceNameOrIdValue = params.getString("serviceNameOrId");
            if (!SVExecutorUtil.validInput(serviceNameOrIdValue)) {
                errorCollection.addError("serviceNameOrId", "Error: Service name or id must be set");
            }
        } else if ("PROJECT".equals(params.getString("serviceSelection")) && !SVExecutorUtil.validInput(projectPathValue = params.getString("projectPath"))) {
            errorCollection.addError("projectPath", "Error: Project path cannot be empty");
        }
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForLists(context);
        context.put("serviceSelection", "SERVICE");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContext(context, taskDefinition);
        this.populateContextForLists(context);
    }

    private void populateContextForLists(Map<String, Object> context) {
        I18nBean textProvider = this.getI18nBean();
        if (SERVICE_SELECTION.isEmpty()) {
            SERVICE_SELECTION.put("SERVICE", textProvider.getText("sv.param.label.selectedServiceOnly"));
            SERVICE_SELECTION.put("PROJECT", textProvider.getText("sv.param.label.allServicesFromProject"));
            SERVICE_SELECTION.put("ALL_DEPLOYED", textProvider.getText("sv.param.label.allServicesDeployedOnServer"));
        }
        context.put("SVServiceSelectionMap", SERVICE_SELECTION);
    }

    private void populateContext(Map<String, Object> context, TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        context.put("url", configuration.get("url"));
        context.put("userName", configuration.get("userName"));
        context.put("password", configuration.get("password"));
        context.put("serviceSelection", configuration.get("serviceSelection"));
        context.put("serviceNameOrId", configuration.get("serviceNameOrId"));
        context.put("projectPath", configuration.get("projectPath"));
        context.put("projectPassword", configuration.get("projectPassword"));
        context.put("targetDirectory", configuration.get("targetDirectory"));
        context.put("force", configuration.get("force"));
        context.put("archive", configuration.get("archive"));
        context.put("switchServiceToStandBy", configuration.get("switchServiceToStandBy"));
        context.put("cleanTargetDirectory", configuration.get("cleanTargetDirectory"));
    }
}

