/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.task;

import com.adm.bamboo.plugin.sv.model.ServiceInfo;
import com.adm.bamboo.plugin.sv.model.SvExportModel;
import com.adm.bamboo.plugin.sv.model.SvServerSettingsModel;
import com.adm.bamboo.plugin.sv.model.SvServiceSelectionModel;
import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.microfocus.sv.svconfigurator.build.ProjectBuilder;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessor;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessorInput;
import com.microfocus.sv.svconfigurator.processor.ExportProcessor;
import com.microfocus.sv.svconfigurator.processor.IChmodeProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.BooleanUtils;

public class SVExportTask
implements TaskType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        Date startDate = new Date();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap map = taskContext.getConfigurationMap();
        String serverURL = (String)map.get((Object)"url");
        String userName = (String)map.get((Object)"userName");
        String userPassword = (String)map.get((Object)"password");
        String projectPath = (String)map.get((Object)"projectPath");
        String projectPassword = (String)map.get((Object)"projectPassword");
        String serviceName = (String)map.get((Object)"serviceNameOrId");
        serviceName = serviceName == null || serviceName.isEmpty() ? null : serviceName;
        boolean force = BooleanUtils.toBoolean((String)map.get((Object)"force"));
        boolean archive = BooleanUtils.toBoolean((String)map.get((Object)"archive"));
        boolean cleanTargetDirectory = BooleanUtils.toBoolean((String)map.get((Object)"cleanTargetDirectory"));
        boolean switchServiceToStandBy = BooleanUtils.toBoolean((String)map.get((Object)"switchServiceToStandBy"));
        String serviceSelection = (String)map.get((Object)"serviceSelection");
        String targetDirectory = (String)map.get((Object)"targetDirectory");
        SvServerSettingsModel svServerSettingsModel = new SvServerSettingsModel(serverURL, userName, userPassword);
        SvServiceSelectionModel svServiceSelectionModel = new SvServiceSelectionModel(serviceName, projectPath, projectPassword);
        svServiceSelectionModel.setSelectionType(serviceSelection);
        SvExportModel svExportModel = new SvExportModel(svServerSettingsModel, svServiceSelectionModel, targetDirectory, cleanTargetDirectory, switchServiceToStandBy, force, archive);
        this.logConfig(buildLogger, svExportModel, startDate, "    ");
        ExportProcessor exportProcessor = new ExportProcessor(null);
        ChmodeProcessor chmodeProcessor = new ChmodeProcessor(null);
        ICommandExecutor commandExecutor = null;
        IProject project = null;
        try {
            commandExecutor = SVExecutorUtil.createCommandExecutor(new URL(svServerSettingsModel.getUrl()), new Credentials(svServerSettingsModel.getUsername(), svServerSettingsModel.getPassword()));
            if (svExportModel.isCleanTargetDirectory()) {
                this.cleanTargetDirectory(buildLogger, targetDirectory);
            }
            if (svServiceSelectionModel.getSelectionType().equals((Object)SvServiceSelectionModel.SelectionType.PROJECT)) {
                project = new ProjectBuilder().buildProject(new File(projectPath), projectPassword);
            }
            List<ServiceInfo> serviceInfoList = SVExecutorUtil.getServiceList(commandExecutor, svServiceSelectionModel, false, buildLogger);
            for (ServiceInfo serviceInfo : serviceInfoList) {
                if (svExportModel.isSwitchToStandByFirst()) {
                    this.switchToStandBy(svExportModel, serviceInfo, chmodeProcessor, commandExecutor, buildLogger);
                }
                buildLogger.addBuildLogEntry(String.format("  Exporting service '%s' [%s] to %s %n", serviceInfo.getName(), serviceInfo.getId(), targetDirectory));
                this.verifyNotLearningBeforeExport(buildLogger, commandExecutor, serviceInfo);
                if (svServiceSelectionModel.getSelectionType().equals((Object)SvServiceSelectionModel.SelectionType.PROJECT)) continue;
                exportProcessor.process(commandExecutor, targetDirectory, serviceInfo.getId(), project, false, svExportModel.isArchive(), false);
            }
            if (svServiceSelectionModel.getSelectionType().equals((Object)SvServiceSelectionModel.SelectionType.PROJECT)) {
                exportProcessor.process(commandExecutor, targetDirectory, null, project, false, svExportModel.isArchive(), false);
            }
        }
        catch (Exception e) {
            TaskResult taskResult;
            try {
                buildLogger.addErrorLogEntry("Build failed: " + e.getMessage(), (Throwable)e);
                taskResult = TaskResultBuilder.create((TaskContext)taskContext).failedWithError().build();
            }
            catch (Throwable throwable) {
                double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
                buildLogger.addBuildLogEntry(String.format("Finished: Export Virtual Service in %.3f seconds%n%n", duration));
                throw throwable;
            }
            double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
            buildLogger.addBuildLogEntry(String.format("Finished: Export Virtual Service in %.3f seconds%n%n", duration));
            return taskResult;
        }
        double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
        buildLogger.addBuildLogEntry(String.format("Finished: Export Virtual Service in %.3f seconds%n%n", duration));
        return TaskResultBuilder.create((TaskContext)taskContext).success().build();
    }

    private void verifyNotLearningBeforeExport(BuildLogger buildLogger, ICommandExecutor exec, ServiceInfo serviceInfo) throws CommunicatorException, CommandExecutorException {
        IService service = exec.findService(serviceInfo.getId(), null);
        ServiceRuntimeConfiguration info = exec.getServiceRuntimeInfo(service);
        if (info.getRuntimeMode() == ServiceRuntimeConfiguration.RuntimeMode.LEARNING) {
            buildLogger.addBuildLogEntry(String.format("    WARNING: Service '%s' [%s] is in Learning mode. Exported model need not be complete!", serviceInfo.getName(), serviceInfo.getId()));
        }
    }

    private void switchToStandBy(SvExportModel svExportModel, ServiceInfo service, IChmodeProcessor chmodeProcessor, ICommandExecutor exec, BuildLogger buildLogger) throws CommandExecutorException, SVCParseException, CommunicatorException {
        buildLogger.addBuildLogEntry(String.format("  Switching service '%s' [%s] to Stand-By mode before export%n", service.getName(), service.getId()));
        ChmodeProcessorInput chmodeInput = new ChmodeProcessorInput(svExportModel.isForce(), null, service.getId(), null, null, ServiceRuntimeConfiguration.RuntimeMode.STAND_BY, false, false);
        chmodeProcessor.process(chmodeInput, exec);
    }

    private void cleanTargetDirectory(BuildLogger buildLogger, String targetDirectory) throws IOException {
        File target = new File(targetDirectory);
        if (target.exists()) {
            File[] subfolders = target.listFiles(DirectoryFileFilter.INSTANCE);
            File[] files = target.listFiles(new SuffixFileFilter(".vproja"));
            if (subfolders.length > 0 || files.length > 0) {
                buildLogger.addBuildLogEntry("  Cleaning target directory...");
            }
            for (File file : files) {
                FileUtils.forceDelete(file);
            }
            for (File subfolder : subfolders) {
                if (subfolder.listFiles(new SuffixFileFilter(".vproj")).length > 0) {
                    buildLogger.addBuildLogEntry("    Deleting subfolder of target directory: " + subfolder.getAbsolutePath());
                    FileUtils.deleteDirectory(subfolder);
                    continue;
                }
                buildLogger.addBuildLogEntry("    Skipping delete of directory '" + subfolder.getAbsolutePath() + "' because it does not contain any *.vproj file.");
            }
        }
    }

    private void logConfig(BuildLogger buildLogger, SvExportModel svExportModel, Date startDate, String prefix) {
        buildLogger.addBuildLogEntry(String.format("%nStarting Export of Virtual Service for SV Server '%s' as %s on %s%n", svExportModel.getServerSettingsModel().getUrl(), svExportModel.getServerSettingsModel().getUsername(), startDate));
        SVExecutorUtil.logConfig(svExportModel.getServiceSelectionModel(), buildLogger, prefix);
        buildLogger.addBuildLogEntry(prefix + "Target Directory: " + svExportModel.getTargetDirectory());
        buildLogger.addBuildLogEntry(prefix + "Clean Target Directory: " + svExportModel.isCleanTargetDirectory());
        buildLogger.addBuildLogEntry(prefix + "Switch to Stand-By: " + svExportModel.isSwitchToStandByFirst());
        buildLogger.addBuildLogEntry(prefix + "Force: " + svExportModel.isForce());
        buildLogger.addBuildLogEntry(prefix + "Archive: " + svExportModel.isArchive());
    }
}

