/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.sv.task;

import com.adm.bamboo.plugin.sv.model.SvDeployModel;
import com.adm.bamboo.plugin.sv.model.SvServerSettingsModel;
import com.adm.utils.sv.SVExecutorUtil;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.microfocus.sv.svconfigurator.build.ProjectBuilder;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.DeployProcessor;
import com.microfocus.sv.svconfigurator.processor.DeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;

public class SVDeployTask
implements TaskType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TaskResult execute(TaskContext taskContext) {
        Date startDate = new Date();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap map = taskContext.getConfigurationMap();
        String serverURL = (String)map.get((Object)"url");
        String userName = (String)map.get((Object)"userName");
        String userPassword = (String)map.get((Object)"password");
        String projectPath = (String)map.get((Object)"projectPath");
        String projectPassword = (String)map.get((Object)"projectPassword");
        String serviceName = (String)map.get((Object)"serviceNameOrId");
        serviceName = serviceName == null || serviceName.isEmpty() ? null : serviceName;
        boolean force = BooleanUtils.toBoolean((String)map.get((Object)"force"));
        boolean firstSuitableAgentFallback = BooleanUtils.toBoolean((String)map.get((Object)"firstSuitableAgentFallback"));
        SvServerSettingsModel svServerSettingsModel = new SvServerSettingsModel(serverURL, userName, userPassword);
        SvDeployModel svDeployModel = new SvDeployModel(svServerSettingsModel, serviceName, force, firstSuitableAgentFallback);
        this.logConfig(buildLogger, svDeployModel, startDate, "    ");
        try {
            IProject project = new ProjectBuilder().buildProject(new File(projectPath), projectPassword);
            this.printProjectContent(project, buildLogger);
            this.deployServiceFromProject(svDeployModel, project, buildLogger);
        }
        catch (ProjectBuilderException e) {
            buildLogger.addErrorLogEntry("Build failed: " + e.getMessage());
            TaskResult taskResult = TaskResultBuilder.create((TaskContext)taskContext).failedWithError().build();
            double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
            buildLogger.addBuildLogEntry(String.format("Finished: Deploy Virtual Service in %.3f seconds%n%n", duration));
            return taskResult;
        }
        catch (Exception e2) {
            buildLogger.addErrorLogEntry("Build failed: " + e2.getMessage(), (Throwable)e2);
            TaskResult taskResult = TaskResultBuilder.create((TaskContext)taskContext).failedWithError().build();
            {
                catch (Throwable throwable) {
                    double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
                    buildLogger.addBuildLogEntry(String.format("Finished: Deploy Virtual Service in %.3f seconds%n%n", duration));
                    throw throwable;
                }
            }
            double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
            buildLogger.addBuildLogEntry(String.format("Finished: Deploy Virtual Service in %.3f seconds%n%n", duration));
            return taskResult;
        }
        double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
        buildLogger.addBuildLogEntry(String.format("Finished: Deploy Virtual Service in %.3f seconds%n%n", duration));
        return TaskResultBuilder.create((TaskContext)taskContext).success().build();
    }

    private void printProjectContent(IProject project, BuildLogger buildLogger) {
        buildLogger.addBuildLogEntry("  Project content:");
        for (IService service : project.getServices()) {
            buildLogger.addBuildLogEntry("    Service: " + service.getName() + " [" + service.getId() + "]");
            for (IDataModel dataModel : service.getDataModels()) {
                buildLogger.addBuildLogEntry("      DM: " + dataModel.getName() + " [" + dataModel.getId() + "]");
            }
            for (IPerfModel perfModel : service.getPerfModels()) {
                buildLogger.addBuildLogEntry("      PM: " + perfModel.getName() + " [" + perfModel.getId() + "]");
            }
        }
    }

    private void deployServiceFromProject(SvDeployModel svDeployModel, IProject project, BuildLogger buildLogger) throws Exception {
        DeployProcessor processor = new DeployProcessor(null);
        ICommandExecutor commandExecutor = SVExecutorUtil.createCommandExecutor(new URL(svDeployModel.getServerSettingsModel().getUrl()), new Credentials(svDeployModel.getServerSettingsModel().getUsername(), svDeployModel.getServerSettingsModel().getPassword()));
        for (IService service : this.getServiceList(svDeployModel, project)) {
            buildLogger.addBuildLogEntry(String.format("  Deploying service '%s' [%s] %n", service.getName(), service.getId()));
            DeployProcessorInput deployInput = new DeployProcessorInput(svDeployModel.isForce(), false, project, svDeployModel.getServiceName(), null, false);
            deployInput.setFirstAgentFailover(svDeployModel.isFirstSuitableAgentFallback());
            processor.process(deployInput, commandExecutor);
        }
    }

    private Iterable<IService> getServiceList(SvDeployModel svDeployModel, IProject project) {
        if (svDeployModel.getServiceName() == null || svDeployModel.getServiceName().isEmpty()) {
            return project.getServices();
        }
        ArrayList<IService> list = new ArrayList<IService>();
        list.add(ProjectUtils.findProjElem(project.getServices(), svDeployModel.getServiceName()));
        return list;
    }

    private void logConfig(BuildLogger buildLogger, SvDeployModel svDeployModel, Date startDate, String prefix) {
        buildLogger.addBuildLogEntry(String.format("%nStarting Deploy Virtual Service for SV Server '%s' as %s on %s%n", svDeployModel.getServerSettingsModel().getUrl(), svDeployModel.getServerSettingsModel().getUsername(), startDate));
        buildLogger.addBuildLogEntry(prefix + "Force: " + svDeployModel.isForce());
        buildLogger.addBuildLogEntry(prefix + "First agent fallback: " + svDeployModel.isFirstSuitableAgentFallback());
    }
}

