/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.performancecenter.impl;

import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TimeslotDuration;
import java.util.Arrays;
import java.util.List;

public class PcModelBamboo {
    private final String pcServerName;
    private final String almUserName;
    private final String almPassword;
    private final String almDomain;
    private final String almProject;
    private final String testId;
    private final String testInstanceId;
    private final String autoTestInstanceID;
    private final TimeslotDuration timeslotDuration;
    private final PostRunAction postRunAction;
    private final boolean vudsMode;
    private final boolean sla;
    private final String description;
    private final String addRunToTrendReport;
    private final boolean HTTPSProtocol;
    private final String proxyOutURL;
    private final String proxyOutUser;
    private final String proxyOutPassword;
    private final boolean authenticateWithToken;
    private String trendReportId;

    public PcModelBamboo(String pcServerName, String almUserName, String almPassword, String almDomain, String almProject, String testId, String autoTestInstanceID, String testInstanceId, String timeslotDurationHours, String timeslotDurationMinutes, PostRunAction postRunAction, boolean vudsMode, boolean sla, String description, String addRunToTrendReport, String trendReportId, boolean HTTPSProtocol, String proxyOutURL, String proxyOutUser, String proxyOutPassword, boolean authenticateWithToken) {
        this.pcServerName = pcServerName;
        this.almUserName = almUserName;
        this.almPassword = almPassword;
        this.almDomain = almDomain;
        this.almProject = almProject;
        this.testId = testId;
        this.autoTestInstanceID = autoTestInstanceID;
        this.testInstanceId = testInstanceId;
        this.timeslotDuration = new TimeslotDuration(timeslotDurationHours, timeslotDurationMinutes);
        this.postRunAction = postRunAction;
        this.vudsMode = vudsMode;
        this.sla = sla;
        this.description = description;
        this.addRunToTrendReport = addRunToTrendReport;
        this.HTTPSProtocol = HTTPSProtocol;
        this.trendReportId = trendReportId;
        this.proxyOutURL = proxyOutURL;
        this.proxyOutUser = proxyOutUser;
        this.proxyOutPassword = proxyOutPassword;
        this.authenticateWithToken = authenticateWithToken;
    }

    public static List<PostRunAction> getPostRunActions() {
        return Arrays.asList(PostRunAction.values());
    }

    public String getPcServerName() {
        return this.pcServerName;
    }

    public String getAlmUserName() {
        return this.almUserName;
    }

    public String getAlmPassword() {
        return this.almPassword;
    }

    public String getAlmDomain() {
        return this.almDomain;
    }

    public String getAlmProject() {
        return this.almProject;
    }

    public String getTestId() {
        return this.testId;
    }

    public String getTestInstanceId() {
        return this.testInstanceId;
    }

    public String getAutoTestInstanceID() {
        return this.autoTestInstanceID;
    }

    public TimeslotDuration getTimeslotDuration() {
        return this.timeslotDuration;
    }

    public boolean isVudsMode() {
        return this.vudsMode;
    }

    public PostRunAction getPostRunAction() {
        return this.postRunAction;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean httpsProtocol() {
        return this.HTTPSProtocol;
    }

    public String getProxyOutURL() {
        return this.proxyOutURL;
    }

    public String getProxyOutUser() {
        return this.proxyOutUser;
    }

    public String getProxyOutPassword() {
        return this.proxyOutPassword;
    }

    public boolean isAuthenticateWithToken() {
        return this.authenticateWithToken;
    }

    public String toString() {
        return String.format("[Server='%s', User='%s', %s", this.runParamsToString().substring(1));
    }

    public String runParamsToString() {
        String vudsModeString = this.vudsMode ? ", VUDsMode='true'" : "";
        String trendString = "USE_ID".equals(this.addRunToTrendReport) ? String.format(", TrendReportID = '%s'", this.trendReportId) : "";
        return String.format("[Domain='%s', Project='%s', TestID='%s', TestInstanceID='%s', TimeslotDuration='%s', PostRunAction='%s'%s%s]", new Object[]{this.almDomain, this.almProject, this.testId, this.testInstanceId, this.timeslotDuration, this.postRunAction, vudsModeString, trendString, this.HTTPSProtocol});
    }

    public String getTrendReportId() {
        return this.trendReportId;
    }

    public void setTrendReportId(String trendReportId) {
        this.trendReportId = trendReportId;
    }

    public String getAddRunToTrendReport() {
        return this.addRunToTrendReport;
    }

    public String isHTTPSProtocol() {
        if (!this.HTTPSProtocol) {
            return "http";
        }
        return "https";
    }
}

