/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.performancecenter;

import com.adm.bamboo.plugin.performancecenter.impl.PcComponentsImpl;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import java.io.IOException;

public class TaskExecution
implements TaskType {
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String PC_SERVER = (String)taskContext.getConfigurationMap().get((Object)"LRE Server");
        String HTTPS = (String)taskContext.getConfigurationMap().get((Object)"https");
        String USER = (String)taskContext.getConfigurationMap().get((Object)"User name");
        String PASSWORD = (String)taskContext.getConfigurationMap().get((Object)"Password");
        String DOMAIN = (String)taskContext.getConfigurationMap().get((Object)"Domain");
        String PROJECT = (String)taskContext.getConfigurationMap().get((Object)"PC Project");
        String TEST_ID = (String)taskContext.getConfigurationMap().get((Object)"Test ID");
        String TEST_INSTANCE_ID_RADIO = (String)taskContext.getConfigurationMap().get((Object)"TestInstanceIDRadio");
        String TEST_INSTANCE_ID = (String)taskContext.getConfigurationMap().get((Object)"Test Instance ID");
        String LOCAL_PROXY = (String)taskContext.getConfigurationMap().get((Object)"Local Proxy");
        String PROXY_USER = (String)taskContext.getConfigurationMap().get((Object)"ProxyUser");
        String PROXY_PASSWORD = (String)taskContext.getConfigurationMap().get((Object)"ProxyPassword");
        String POST_RUN_ACTION = (String)taskContext.getConfigurationMap().get((Object)"postRunAction");
        String TRENDING_RADIO = (String)taskContext.getConfigurationMap().get((Object)"trendingRadio");
        String TREND_REPORT_ID = (String)taskContext.getConfigurationMap().get((Object)"Trend Report ID");
        String TIMESLOT_HOURS = (String)taskContext.getConfigurationMap().get((Object)"Hours");
        String TIMESLOT_MINUTES = (String)taskContext.getConfigurationMap().get((Object)"Minutes");
        String VUDS = (String)taskContext.getConfigurationMap().get((Object)"vuds");
        String SLA2 = (String)taskContext.getConfigurationMap().get((Object)"sla");
        String AUTHENTICATE_WITH_TOKEN = (String)taskContext.getConfigurationMap().get((Object)"authenticateWithToken");
        PcComponentsImpl r = new PcComponentsImpl(taskContext, buildLogger, PC_SERVER, USER, PASSWORD, DOMAIN, PROJECT, TEST_ID, TEST_INSTANCE_ID_RADIO, TEST_INSTANCE_ID, TIMESLOT_HOURS, TIMESLOT_MINUTES, this.convertStringBackToPostRunAction(POST_RUN_ACTION), Boolean.parseBoolean(VUDS), Boolean.parseBoolean(SLA2), "", TRENDING_RADIO, TREND_REPORT_ID, Boolean.parseBoolean(HTTPS), LOCAL_PROXY, PROXY_USER, PROXY_PASSWORD, Boolean.parseBoolean(AUTHENTICATE_WITH_TOKEN));
        try {
            if (!r.pcAuthenticate().booleanValue()) {
                throw new PcException("Unable to login");
            }
            buildLogger.addBuildLogEntry("Executing Load Test:");
            buildLogger.addBuildLogEntry("====================");
            buildLogger.addBuildLogEntry("Test ID:" + TEST_ID);
            if ("AUTO".equals(TEST_INSTANCE_ID_RADIO)) {
                buildLogger.addBuildLogEntry("Test Instance ID:" + TEST_INSTANCE_ID_RADIO);
            } else {
                buildLogger.addBuildLogEntry("Test Instance ID:" + TEST_INSTANCE_ID);
            }
            buildLogger.addBuildLogEntry("Timeslot Duration::" + TIMESLOT_HOURS + ":" + TIMESLOT_MINUTES + " (h:mm)");
            buildLogger.addBuildLogEntry("Post Run Action:" + POST_RUN_ACTION);
            buildLogger.addBuildLogEntry("Use VUDS:" + ("true".equals(VUDS.toLowerCase()) ? "true" : "false"));
            buildLogger.addBuildLogEntry("====================");
            String runID = r.startRun();
            buildLogger.addBuildLogEntry("====================");
            if (Boolean.parseBoolean(SLA2) && !r.isSlaStatusPassed().booleanValue()) {
                buildLogger.addErrorLogEntry("Run measurements did not reach SLA criteria. Run SLA Status: " + r.getRunSLAStatus());
                return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            buildLogger.addErrorLogEntry("Error while executing load test: " + e.toString());
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        catch (PcException e) {
            e.printStackTrace();
            buildLogger.addErrorLogEntry("Error while executing load test: " + e.toString());
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            buildLogger.addErrorLogEntry("Error while executing load test: " + e.toString());
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private PostRunAction convertStringBackToPostRunAction(String postRunAction) {
        for (PostRunAction p : PostRunAction.values()) {
            if (!postRunAction.replaceAll("_", " ").equals(p.getValue())) continue;
            return p;
        }
        return PostRunAction.DO_NOTHING;
    }
}

