/*
 * Decompiled with CFR 0.152.
 */
package com.adm.bamboo.plugin.performancecenter;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PostRunAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TaskConfigurator
extends AbstractTaskConfigurator {
    public static final String PC_SERVER = "LRE Server";
    public static final String USER = "User name";
    public static final String HTTPS = "https";
    public static final String PASSWORD = "Password";
    public static final String DOMAIN = "Domain";
    public static final String PROJECT = "PC Project";
    public static final String TEST_ID = "Test ID";
    public static final String TEST_INSTANCE_ID = "Test Instance ID";
    public static final String TEST_INSTANCE_ID_RADIO = "TestInstanceIDRadio";
    public static final String LOCAL_PROXY = "Local Proxy";
    public static final String PROXY_USER = "ProxyUser";
    public static final String PROXY_PASSWORD = "ProxyPassword";
    public static final String POST_RUN_ACTION = "postRunAction";
    public static final String TRENDING_RADIO = "trendingRadio";
    public static final String TREND_REPORT_ID = "Trend Report ID";
    public static final String TIMESLOT_HOURS = "Hours";
    public static final String TIMESLOT_MINUTES = "Minutes";
    public static final String VUDS = "vuds";
    public static final String SLA = "sla";
    public static final String AUTHENTICATE_WITH_TOKEN = "authenticateWithToken";
    public static final String COLLATE = "Collate Results";
    public static final String COLLATE_ANALYZE = "Collate and Analyze";
    public static final String DO_NOTHING = "Do Not Collate";
    private static final String REGEX = "^\\$\\{.*\\}$|^[0-9]*$";
    public Map<String, String> postRunActionMap = new LinkedHashMap<String, String>();
    public Map<String, String> testInstanceMap = new LinkedHashMap<String, String>();
    public Map<String, String> trendReportMap = new LinkedHashMap<String, String>();
    ArrayList<String> localDAtaArray = new ArrayList();

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(PC_SERVER, params.getString(PC_SERVER));
        config.put(USER, params.getString(USER));
        config.put(HTTPS, params.getString(HTTPS));
        config.put(PASSWORD, params.getString(PASSWORD));
        config.put(DOMAIN, params.getString(DOMAIN));
        config.put(PROJECT, params.getString(PROJECT));
        config.put(TEST_ID, params.getString(TEST_ID));
        config.put(TEST_INSTANCE_ID, params.getString(TEST_INSTANCE_ID));
        config.put(TEST_INSTANCE_ID_RADIO, params.getString(TEST_INSTANCE_ID_RADIO));
        config.put(LOCAL_PROXY, params.getString(LOCAL_PROXY));
        config.put(PROXY_USER, params.getString(PROXY_USER));
        config.put(PROXY_PASSWORD, params.getString(PROXY_PASSWORD));
        config.put(POST_RUN_ACTION, params.getString(POST_RUN_ACTION));
        config.put(TREND_REPORT_ID, params.getString(TREND_REPORT_ID));
        config.put(TRENDING_RADIO, params.getString(TRENDING_RADIO));
        config.put(TIMESLOT_HOURS, params.getString(TIMESLOT_HOURS));
        config.put(TIMESLOT_MINUTES, params.getString(TIMESLOT_MINUTES));
        config.put(VUDS, params.getString(VUDS));
        config.put(SLA, params.getString(SLA));
        config.put(AUTHENTICATE_WITH_TOKEN, params.getString(AUTHENTICATE_WITH_TOKEN));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        this.updateLocalArray();
        super.validate(params, errorCollection);
        for (String p : this.localDAtaArray) {
            String val = params.getString(p);
            if (StringUtils.equals(p, TEST_INSTANCE_ID) && !StringUtils.equals(params.getString(TEST_INSTANCE_ID_RADIO), "AUTO") || StringUtils.equals(p, TEST_ID) || StringUtils.equals(p, TREND_REPORT_ID) && StringUtils.equals(params.getString(TRENDING_RADIO), "USE_ID")) {
                if (StringUtils.isEmpty(val)) {
                    errorCollection.addError(p, "Required!");
                    continue;
                }
                if (val.matches(REGEX)) continue;
                errorCollection.addError(p, "Must be numeric or a variable (e.g. ${value}).");
                continue;
            }
            if (!StringUtils.isEmpty(val) || StringUtils.equals(p, PASSWORD) || StringUtils.equals(p, TEST_INSTANCE_ID) || StringUtils.equals(p, TREND_REPORT_ID)) continue;
            errorCollection.addError(p, "Required!");
        }
    }

    private void updateLocalArray() {
        this.localDAtaArray.clear();
        this.localDAtaArray.add(PC_SERVER);
        this.localDAtaArray.add(USER);
        this.localDAtaArray.add(PASSWORD);
        this.localDAtaArray.add(DOMAIN);
        this.localDAtaArray.add(PROJECT);
        this.localDAtaArray.add(TEST_ID);
        this.localDAtaArray.add(TEST_INSTANCE_ID_RADIO);
        this.localDAtaArray.add(TEST_INSTANCE_ID);
        this.localDAtaArray.add(TIMESLOT_HOURS);
        this.localDAtaArray.add(TIMESLOT_MINUTES);
        this.localDAtaArray.add(TREND_REPORT_ID);
        this.postRunActionMap.put(PostRunAction.DO_NOTHING.getValue().replaceAll(" ", "_"), PostRunAction.DO_NOTHING.getValue());
        this.postRunActionMap.put(PostRunAction.COLLATE.getValue().replaceAll(" ", "_"), PostRunAction.COLLATE.getValue());
        this.postRunActionMap.put(PostRunAction.COLLATE_AND_ANALYZE.getValue().replaceAll(" ", "_"), PostRunAction.COLLATE_AND_ANALYZE.getValue());
        this.testInstanceMap.put("AUTO", "Automatically select existing or create new if none exists (Performance Center 12.55 or later)");
        this.testInstanceMap.put("MANUAL", "Manual selection");
        this.trendReportMap.put("NO_TREND", "Do Not Trend");
        this.trendReportMap.put("ASSOCIATED", "Use trend report associated with the test - Performance Center 12.55 or later");
        this.trendReportMap.put("USE_ID", "Add run to trend report with ID");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        this.updateLocalArray();
        context.put("postRunActionList", this.postRunActionMap);
        context.put("testInstanceList", this.testInstanceMap);
        context.put("trendReporList", this.trendReportMap);
        context.put(PC_SERVER, taskDefinition.getConfiguration().get(PC_SERVER));
        context.put(AUTHENTICATE_WITH_TOKEN, taskDefinition.getConfiguration().get(AUTHENTICATE_WITH_TOKEN));
        context.put(USER, taskDefinition.getConfiguration().get(USER));
        context.put(HTTPS, taskDefinition.getConfiguration().get(HTTPS));
        context.put(PASSWORD, taskDefinition.getConfiguration().get(PASSWORD));
        context.put(DOMAIN, taskDefinition.getConfiguration().get(DOMAIN));
        context.put(PROJECT, taskDefinition.getConfiguration().get(PROJECT));
        context.put(TEST_ID, taskDefinition.getConfiguration().get(TEST_ID));
        context.put(TEST_INSTANCE_ID, taskDefinition.getConfiguration().get(TEST_INSTANCE_ID));
        context.put(TEST_INSTANCE_ID_RADIO, taskDefinition.getConfiguration().get(TEST_INSTANCE_ID_RADIO));
        context.put(LOCAL_PROXY, taskDefinition.getConfiguration().get(LOCAL_PROXY));
        context.put(PROXY_USER, taskDefinition.getConfiguration().get(PROXY_USER));
        context.put(PROXY_PASSWORD, taskDefinition.getConfiguration().get(PROXY_PASSWORD));
        context.put(POST_RUN_ACTION, taskDefinition.getConfiguration().get(POST_RUN_ACTION));
        context.put(TRENDING_RADIO, taskDefinition.getConfiguration().get(TRENDING_RADIO));
        context.put(TREND_REPORT_ID, taskDefinition.getConfiguration().get(TREND_REPORT_ID));
        context.put(TIMESLOT_HOURS, taskDefinition.getConfiguration().get(TIMESLOT_HOURS));
        context.put(TIMESLOT_MINUTES, taskDefinition.getConfiguration().get(TIMESLOT_MINUTES));
        context.put(VUDS, taskDefinition.getConfiguration().get(VUDS));
        context.put(SLA, taskDefinition.getConfiguration().get(SLA));
    }

    public void populateContextForCreate(Map<String, Object> context) {
        this.updateLocalArray();
        super.populateContextForCreate(context);
        context.put("postRunActionList", this.postRunActionMap);
        context.put("testInstanceList", this.testInstanceMap);
        context.put("trendReporList", this.trendReportMap);
        context.put(TIMESLOT_HOURS, "0");
        context.put(TIMESLOT_MINUTES, "30");
    }
}

