/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.util;

import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import java.util.Collection;

public class ProjectUtils {
    public static final String ENTITY_VIRTUAL_SERVICE = "Virtual service";
    public static final String ENTITY_DATA_MODEL = "Data model";
    public static final String ENTITY_PERFORMANCE_MODEL = "Performance model";

    public static <E extends IProjectElement> E findProjElem(Collection<E> elems, String ident) {
        if (ident == null) {
            return null;
        }
        for (IProjectElement elem : elems) {
            if (!elem.getId().equals(ident) && !elem.getName().equals(ident)) continue;
            return (E)elem;
        }
        throw new IllegalArgumentException("Element [" + ident + "] was not found.");
    }

    public static <E extends IProjectElement> E findProjElem(Collection<E> elems, String ident, String entityType) throws CommandExecutorException {
        try {
            return ProjectUtils.findProjElem(elems, ident);
        }
        catch (IllegalArgumentException e) {
            throw new CommandExecutorException(entityType + " '" + ident + "' not found in the project");
        }
    }

    public static Credentials createCredentials(String username, String password) {
        return username != null ? new Credentials(username, password) : null;
    }

    public static String decodeInclude(String file) {
        if (file == null) {
            return null;
        }
        return file.replace("%24", "$").replace("%40", "@").replace("%27", "'").replace("%3B", ";").replace("%3F", "?").replace("%2A", "*").replace("%25", "%");
    }

    public static String encodeInclude(String file) {
        return file.replace("%", "%25").replace("$", "%24").replace("@", "%40").replace("'", "%27").replace(";", "%3B").replace("?", "%3F").replace("*", "%2A");
    }
}

