/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServerInfo;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.processor.export.AbstractWriter;
import com.microfocus.sv.svconfigurator.processor.export.FolderWriter;
import com.microfocus.sv.svconfigurator.processor.export.ZipWriter;
import com.microfocus.sv.svconfigurator.processor.utils.DataModelContentFilesExtractor;
import com.microfocus.sv.svconfigurator.processor.utils.DataModelScaExtractor;
import com.microfocus.sv.svconfigurator.serverclient.FileInfo;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import com.microfocus.sv.svconfigurator.serverclient.IServerManagementEndpointClient;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ExportProcessor {
    public static final String SERVER_TYPE_EMBEDDED = "Embedded";
    public static final String EMBEDDED_SERVER_URN = "urn:Embedded Server";
    private static final int FETCH_COUNT_LIMIT = 1000;
    private ICommandExecutorFactory commandExecutorFactory;
    private static final Logger LOG = LoggerFactory.getLogger(ExportProcessor.class);

    public ExportProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    public void process(ICommandExecutor exec, String directory, String svc, IProject project, boolean ignoreErrors, boolean exportAsArchive, boolean includeLoggedMessages) throws Exception {
        File root = new File(directory);
        if (!root.exists()) {
            if (!root.mkdirs()) {
                throw new CommandExecutorException("Cannot create output directory: " + directory);
            }
        } else if (!root.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + directory);
        }
        ServiceListAtom services = exec.getServiceList(null);
        HashMap<String, ArrayList<ServiceListAtom.ServiceEntry>> projects = new HashMap<String, ArrayList<ServiceListAtom.ServiceEntry>>();
        for (ServiceListAtom.ServiceEntry serviceEntry : services.getEntries()) {
            if (svc != null && !svc.equals(serviceEntry.getId()) && !svc.equals(serviceEntry.getTitle()) || project != null && !this.isServiceInProject(serviceEntry.getId(), project)) continue;
            ArrayList<ServiceListAtom.ServiceEntry> e = (ArrayList<ServiceListAtom.ServiceEntry>)projects.get(serviceEntry.getProjectId());
            if (e == null) {
                e = new ArrayList<ServiceListAtom.ServiceEntry>();
                projects.put(serviceEntry.getProjectId(), e);
            }
            e.add(serviceEntry);
        }
        for (Map.Entry entry : projects.entrySet()) {
            this.saveProject((List)entry.getValue(), root, exec, ignoreErrors, exportAsArchive, includeLoggedMessages);
        }
        if (projects.isEmpty()) {
            LOG.info("Successfully finished, but no project was exported.");
        } else {
            LOG.info("Successfully finished");
        }
    }

    private boolean isServiceInProject(String serviceId, IProject project) {
        for (IService svc : project.getServices()) {
            if (!serviceId.equals(svc.getId())) continue;
            return true;
        }
        return false;
    }

    private void saveProject(List<ServiceListAtom.ServiceEntry> serviceEntries, File root, ICommandExecutor exec, boolean ignoreErrors, boolean exportAsArchive, boolean includeLoggedMessages) throws Exception {
        ServiceListAtom.ServiceEntry firstService = serviceEntries.get(0);
        String projectName = firstService.getProjectName();
        if (projectName == null) {
            projectName = firstService.getTitle() + " Project";
        }
        AbstractWriter writer = exportAsArchive ? new ZipWriter(root, projectName) : new FolderWriter(root, projectName);
        ArrayList<String> projectEntries = new ArrayList<String>();
        int vsIndex = 0;
        HashMap scaSdIds2ServiceIds = new HashMap();
        HashMap<String, HashSet<String>> service2ContentFileIds = new HashMap<String, HashSet<String>>();
        for (ServiceListAtom.ServiceEntry serviceEntry : serviceEntries) {
            ArrayList<String> serviceFiles = new ArrayList<String>();
            HashMap serviceScaIds = new HashMap();
            HashSet<String> contentFileIds = new HashSet<String>();
            try {
                this.saveService(serviceFiles, writer, serviceEntry, exec, vsIndex++, serviceScaIds, contentFileIds, includeLoggedMessages);
                service2ContentFileIds.put(serviceEntry.getId(), contentFileIds);
                projectEntries.addAll(serviceFiles);
                scaSdIds2ServiceIds.putAll(serviceScaIds);
                writer.commit();
            }
            catch (Exception e) {
                LOG.error("Failed to save virtual service '" + serviceEntry.getTitle() + "'. Project: '" + projectName + "'", e);
                if (!ignoreErrors) {
                    throw e;
                }
                writer.rollback();
            }
        }
        int scaSdIndex = 0;
        for (String sdId : scaSdIds2ServiceIds.keySet()) {
            this.writeServiceDataToFile(exec.getClient().fetchServiceDescription((String)scaSdIds2ServiceIds.get(sdId), sdId), writer, projectName, " SCA-SD " + scaSdIndex++ + ".vsdsc", projectEntries);
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        HashSet<String> processedContentFileIds = new HashSet<String>();
        for (String vsId : service2ContentFileIds.keySet()) {
            HashSet contentFileIds = (HashSet)service2ContentFileIds.get(vsId);
            for (String cfId : contentFileIds) {
                if (processedContentFileIds.contains(cfId)) continue;
                byte[] contentFile = exec.getClient().fetchContentFile(vsId, cfId);
                HashMap<String, String> contentFileMetadata = new HashMap<String, String>();
                byte[] rawContentFile = this.extractContentFile(contentFile, contentFileMetadata);
                writer.addData(this.getContentFilePath(contentFileMetadata), rawContentFile);
                arrayList.add(contentFileMetadata);
                processedContentFileIds.add(cfId);
            }
        }
        String serverUrl = String.valueOf(exec.getClient().getMgmtUri()).replaceAll("/+$", "");
        ServerInfo serverInfo = exec.getClient().getServerInfo();
        String serverEdition = serverInfo.getServerEditionName();
        String serverVersion = serverInfo.getServerVersion();
        String serverType = serverInfo.getServerType();
        String serverIdentifier = SERVER_TYPE_EMBEDDED.equals(serverType) ? EMBEDDED_SERVER_URN : serverUrl;
        byte[] projectFilePayload = this.createVproj(projectEntries, arrayList, firstService.getProjectId(), serverUrl, serverVersion, serverEdition, serverIdentifier).getBytes("UTF-8");
        writer.addData(projectName + ".vproj", projectFilePayload);
        writer.commit();
        writer.close();
    }

    private byte[] extractContentFile(byte[] contentFile, Map<String, String> metadata) throws SVCParseException {
        Document doc;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(contentFile);
            doc = XmlUtils.createDoc(bis);
        }
        catch (Exception e) {
            try {
                throw new SVCParseException("Failed to parse content file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bis);
        if (doc != null) {
            try {
                metadata.putAll(XmlUtils.getNodeAsKeyValueMap(doc.getLastChild(), (short)2));
                if (metadata.containsKey("xmlns")) {
                    metadata.remove("xmlns");
                }
                return Base64.decodeBase64(doc.getLastChild().getTextContent().getBytes());
            }
            catch (Exception e) {
                throw new SVCParseException("Content File metadata extraction failed", e);
            }
        }
        return null;
    }

    private String getContentFilePath(Map<String, String> metadata) throws SVCParseException {
        String pathMetadataName = "name";
        if (metadata.containsKey("name")) {
            return metadata.get("name");
        }
        throw new SVCParseException("Content File doesn't contain 'name' attribute.");
    }

    private String createVproj(List<String> files, List<Map<String, String>> contentFilesMetadata, String projectId, String serverUrl, String serverVersion, String serverEdition, String serverIdentifier) throws SVCParseException {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("<Project ToolsVersion=\"4.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\" DefaultTargets=\"Build\"><PropertyGroup><ProjectGuid>");
        sb.append(projectId);
        sb.append("</ProjectGuid><Configuration Condition=\" '$(Configuration)' == '' \">Debug</Configuration><Platform Condition=\" '$(Platform)' == '' \">x86</Platform><ServerIdentifier>").append(serverIdentifier).append("</ServerIdentifier><ServerUrl>").append(serverUrl).append("</ServerUrl><ProductVersion>").append(serverVersion).append("</ProductVersion><ProductEdition>").append(serverEdition).append("</ProductEdition></PropertyGroup><PropertyGroup Condition=\" '$(Platform)' == 'x86' \"><PlatformTarget>x86</PlatformTarget></PropertyGroup><ItemGroup>");
        for (String string : files) {
            sb.append("<None Include=\"").append(string).append("\" />");
        }
        for (Map map : contentFilesMetadata) {
            String contentFilePath = this.getContentFilePath(map);
            sb.append("<Content Include=\"").append(contentFilePath).append("\">");
            for (String metadataKey : map.keySet()) {
                sb.append("<").append(metadataKey).append(">").append((String)map.get(metadataKey)).append("</").append(metadataKey).append(">");
            }
            sb.append("</Content>");
        }
        sb.append("</ItemGroup></Project>");
        return sb.toString();
    }

    private void saveService(List<String> files, AbstractWriter writer, ServiceListAtom.ServiceEntry entry, ICommandExecutor exec, int vsIndex, HashMap<String, String> scaSdIds2ServiceIds, Set<String> projectContentFileIds, boolean includeLoggedMessages) throws Exception {
        String serviceName = entry.getTitle() + " " + vsIndex;
        serviceName = AbstractWriter.entityNameToFileName(serviceName);
        LOG.info("  writing virtual service '" + serviceName + "'...");
        String vsId = entry.getId();
        IServerManagementEndpointClient client = exec.getClient();
        this.writeServiceDataToFile(client.fetchVirtualService(vsId), writer, serviceName, ".vs", files);
        Collection<String> pmIds = client.getPerformanceModelIds(vsId);
        int pmIndex = 0;
        for (String pmId : pmIds) {
            this.writeServiceDataToFile(client.fetchPerformanceModel(vsId, pmId), writer, serviceName, " PM " + pmIndex++ + ".vspfmodel", files);
        }
        HashSet<String> scaSdIds = new HashSet<String>();
        Collection<String> vsSdIds = client.getServiceDescriptionIds(vsId);
        Collection<String> dmIds = client.getDataModelIds(vsId);
        HashSet<String> contentFileIds = new HashSet<String>();
        HashMap<String, Dataset> datasets = new HashMap<String, Dataset>();
        HashMap<String, Collection<String>> dm2refIds = new HashMap<String, Collection<String>>();
        int dmIndex = 0;
        int dsIndex = 0;
        for (String string : dmIds) {
            byte[] dataModel = client.fetchDataModel(vsId, string);
            this.writeServiceDataToFile(dataModel, writer, serviceName, " DM " + dmIndex++ + ".vsmodel", files);
            HashSet<String> datamodelRefIds = new HashSet<String>();
            dm2refIds.put(string, datamodelRefIds);
            datamodelRefIds.addAll(vsSdIds);
            try {
                HashSet<String> dmContentFileIds = new HashSet<String>();
                DataModelContentFilesExtractor.extractContentFileIds(dataModel, dmContentFileIds);
                contentFileIds.addAll(dmContentFileIds);
                datamodelRefIds.addAll(dmContentFileIds);
                Set<String> dmScaSdIds = DataModelScaExtractor.extractScaServiceDescriptionIds(dataModel);
                if (dmScaSdIds != null) {
                    for (String sdId : dmScaSdIds) {
                        scaSdIds2ServiceIds.put(sdId, vsId);
                    }
                    datamodelRefIds.addAll(dmScaSdIds);
                    scaSdIds.addAll(dmScaSdIds);
                }
            }
            catch (AbstractSVCException e) {
                LOG.error("Failed to parse DM '" + serviceName + "' for SCAs.", e);
                throw e;
            }
            Collection<String> dsIds = client.getDataSetIds(vsId, string);
            for (String dsId : dsIds) {
                byte[] dataSet = client.fetchDataSet(vsId, string, dsId);
                this.writeServiceDataToFile(dataSet, writer, serviceName, " DS " + dsIndex++ + ".vsdataset", files);
                Dataset dataset = this.parseDataset(dataSet, dsId);
                datasets.put(dataset.id, dataset);
                datamodelRefIds.add(dataset.id);
            }
        }
        int sdIndex = 0;
        for (String sdId : vsSdIds) {
            this.writeServiceDataToFile(client.fetchServiceDescription(vsId, sdId), writer, serviceName, " SD " + sdIndex++ + ".vsdsc", files);
        }
        String string = this.createMetafile(vsId, vsSdIds, scaSdIds, pmIds, dmIds, dm2refIds, datasets, contentFileIds);
        this.writeServiceDataToFile(string.getBytes("UTF-8"), writer, serviceName, ".vsmf", files);
        projectContentFileIds.addAll(contentFileIds);
        if (includeLoggedMessages) {
            this.saveLoggedMessages(serviceName, vsId, client, writer);
        }
    }

    private void saveLoggedMessages(String serviceName, String vsId, IServerManagementEndpointClient client, AbstractWriter writer) throws Exception {
        FileInfo fileInfo;
        long from = 0L;
        int counter = 1;
        while ((fileInfo = client.fetchLoggedMessages(vsId, from, 1000)) != null) {
            from = this.getLastId(fileInfo.getFileName()) + 1;
            String filePath = serviceName + " " + String.format("%03d", counter) + ".msglog";
            writer.addData(filePath, fileInfo.getContent());
            ++counter;
        }
    }

    private int getLastId(String fileName) throws SVCParseException {
        try {
            int fromIndex = fileName.lastIndexOf("_") + 1;
            int toIndex = fileName.indexOf(".");
            return Integer.parseInt(fileName.substring(fromIndex, toIndex));
        }
        catch (Exception e) {
            throw new SVCParseException("Received fileName [" + fileName + "] with unrecognized format, expected [calls_<from>_<to>.xml]");
        }
    }

    private Dataset parseDataset(byte[] dataSet, String dsId) throws UnsupportedEncodingException {
        String x = new String(dataSet, "ASCII");
        int idx = x.indexOf("hc=\"");
        int endIdx = x.indexOf("\"", idx + 4);
        String hc = x.substring(idx + 4, endIdx);
        return new Dataset(dsId, hc);
    }

    private void writeServiceDataToFile(byte[] data, AbstractWriter writer, String serviceName, String fileSuffix, List<String> projectEntries) throws IOException {
        String filePath = serviceName + fileSuffix;
        projectEntries.add(filePath);
        writer.addData(filePath, data);
    }

    private String createMetafile(String vsId, Collection<String> sdIds, Collection<String> scaSdIds, Collection<String> pmIds, Collection<String> dmIds, Map<String, Collection<String>> dm2refIds, Map<String, Dataset> datasets, Set<String> contentFileIds) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\r\n");
        sb.append("<deploymentManifest id=\"manifest_");
        sb.append(vsId);
        sb.append("\" rootItemId=\"");
        sb.append(vsId);
        sb.append("\" xmlns=\"http://hp.com/SOAQ/ServiceVirtualization/2010/\">");
        ArrayList<String> vsRefs = new ArrayList<String>();
        vsRefs.addAll(pmIds);
        vsRefs.addAll(dmIds);
        vsRefs.addAll(sdIds);
        sb.append(this.writeItem(vsId, vsRefs, "VirtualService", null));
        for (String dmId : dmIds) {
            Collection<String> dmRefs = dm2refIds.get(dmId);
            sb.append(this.writeItem(dmId, dmRefs, "DataModel", null));
        }
        for (String pmId : pmIds) {
            sb.append(this.writeItem(pmId, null, "PerformanceModel", null));
        }
        for (Dataset ds : datasets.values()) {
            sb.append(this.writeItem(ds.id, null, "Dataset", ds.hc));
        }
        HashSet<String> sdItems = new HashSet<String>();
        sdItems.addAll(sdIds);
        sdItems.addAll(scaSdIds);
        for (String sdId : sdItems) {
            sb.append(this.writeItem(sdId, null, "ServiceDescription", null));
        }
        for (String contentFileId : contentFileIds) {
            sb.append(this.writeItem(contentFileId, null, "ContentFile", null));
        }
        sb.append("</deploymentManifest>");
        return sb.toString();
    }

    private String writeItem(String id, Collection<String> references, String type, String hc) {
        StringBuilder sb = new StringBuilder("<Item id=\"");
        sb.append(id);
        sb.append("\" type=\"");
        sb.append(type);
        if (hc != null) {
            sb.append("\" contentHashcode=\"");
            sb.append(hc);
        }
        sb.append("\">");
        if (references == null || references.isEmpty()) {
            sb.append("<References />");
        } else {
            sb.append("<References>");
            for (String x : references) {
                sb.append("<Ref id=\"");
                sb.append(x);
                sb.append("\" />");
            }
            sb.append("</References>");
        }
        sb.append("</Item>");
        return sb.toString();
    }

    private static class Dataset {
        private String id;
        private String hc;

        private Dataset(String id, String hc) {
            this.id = id;
            this.hc = hc;
        }
    }
}

