/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.server;

import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServersCommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ServersCommandExecutor.class);
    private final List<Server> servers;
    private final ICommandExecutorFactory commandExecutorFactory;

    public ServersCommandExecutor(List<Server> servers, ICommandExecutorFactory commandExecutorFactory) throws CommandExecutorException {
        if (servers == null) {
            throw new CommandExecutorException("No servers defined");
        }
        if (commandExecutorFactory == null) {
            throw new CommandExecutorException("No command executor factory defined.");
        }
        this.servers = new ArrayList<Server>(servers);
        this.commandExecutorFactory = commandExecutorFactory;
    }

    public void execute(IServerCommandRunner runner) throws AbstractSVCException {
        if (runner == null) {
            throw new CommandExecutorException("No runner defined");
        }
        for (Server server : this.servers) {
            ICommandExecutor executor;
            try {
                executor = this.commandExecutorFactory.createCommandExecutor(server.getURL(), server.isTrustEveryone(), server.getCredentials());
            }
            catch (AbstractSVCException e) {
                throw new CommandExecutorException("Failed to initiate connection to " + this.getServerIdentifier(server) + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new CommandExecutorException("Failed to initiate connection to " + this.getServerIdentifier(server), e);
            }
            if (executor == null) {
                throw new CommandExecutorException("No command executor found for " + this.getServerIdentifier(server));
            }
            try {
                LOG.debug("Running command for " + this.getServerIdentifier(server) + "'...");
                runner.runCommand(executor);
                LOG.info("Command successfully finished for " + this.getServerIdentifier(server));
            }
            catch (AbstractSVCException e) {
                throw new CommandExecutorException("Failed to run command for " + this.getServerIdentifier(server) + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new CommandExecutorException("Failed to run command for " + this.getServerIdentifier(server), e);
            }
        }
    }

    private String getServerIdentifier(Server server) {
        if ("Default".equals(server.getId())) {
            return "server " + server.getURL();
        }
        return "server " + server.getURL() + " (id: " + server.getId() + ")";
    }
}

