/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl;

import com.microfocus.sv.svconfigurator.core.AbstractProjectElement;
import com.microfocus.sv.svconfigurator.core.IContentFile;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.IProjectElementVisitor;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.encryption.EncryptionMetadata;
import com.microfocus.sv.svconfigurator.processor.printer.NonPrintable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Service
extends AbstractProjectElement
implements IService {
    private Set<IDataModel> dataModels;
    private Set<IPerfModel> perfModels;
    @NonPrintable
    private Set<IServiceDescription> svcDescs;
    @NonPrintable
    private Set<IContentFile> contentFiles;
    @NonPrintable
    private IProject baseProject;
    private String runtimeIssues;
    @NonPrintable
    private boolean nonExistentRealService;
    @NonPrintable
    private Set<ILoggedServiceCallList> loggedServiceCallLists;

    public Service(String id, String name, IProjectElementDataSource ds, EncryptionMetadata encryptionMetadata, String projectPassword, String runtimeIssues, boolean nonExistentRealService) {
        super(id, name, ds, encryptionMetadata, projectPassword);
        this.runtimeIssues = runtimeIssues;
        this.dataModels = new HashSet<IDataModel>();
        this.perfModels = new HashSet<IPerfModel>();
        this.svcDescs = new HashSet<IServiceDescription>();
        this.contentFiles = new HashSet<IContentFile>();
        this.loggedServiceCallLists = new HashSet<ILoggedServiceCallList>();
        this.baseProject = null;
        this.nonExistentRealService = nonExistentRealService;
    }

    public Service(String id, String name) {
        this(id, name, null, null, null, null, false);
    }

    @Override
    public void accept(IProjectElementVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "Service[" + this.getName() + "]";
    }

    @Override
    public Collection<IDataModel> getDataModels() {
        return this.dataModels;
    }

    @Override
    public Collection<IPerfModel> getPerfModels() {
        return this.perfModels;
    }

    @Override
    public Collection<IServiceDescription> getDescriptions() {
        return this.svcDescs;
    }

    @Override
    public Collection<IContentFile> getContentFiles() {
        return this.contentFiles;
    }

    @Override
    public Collection<ILoggedServiceCallList> getLoggedServiceCallLists() {
        return this.loggedServiceCallLists;
    }

    @Override
    public void addDescription(IServiceDescription sd) {
        this.svcDescs.add(sd);
    }

    @Override
    public void addContentFile(IContentFile cf) {
        this.contentFiles.add(cf);
    }

    @Override
    public void addLoggedServiceCallList(ILoggedServiceCallList loggedServiceCallList) {
        this.loggedServiceCallLists.add(loggedServiceCallList);
    }

    @Override
    public String getRuntimeIssues() {
        return this.runtimeIssues;
    }

    @Override
    public boolean NonExistentRealService() {
        return this.nonExistentRealService;
    }

    @Override
    public void addDataModel(IDataModel dm) {
        this.dataModels.add(dm);
        dm.setService(this);
    }

    @Override
    public void addPerfModel(IPerfModel pm) {
        this.perfModels.add(pm);
        pm.setService(this);
    }

    @Override
    public IProject getBaseProject() {
        if (this.baseProject == null) {
            throw new IllegalStateException("ReferenceElement is not initialized - it does not belong to any project.");
        }
        return this.baseProject;
    }

    @Override
    public void setBaseProject(IProject baseProject) {
        if (this.baseProject != null) {
            throw new IllegalStateException("ReferenceElement can belong to only one p");
        }
        this.baseProject = baseProject;
    }
}

