/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl;

import com.microfocus.sv.svconfigurator.core.AbstractProjectElement;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.IProjectElementVisitor;
import com.microfocus.sv.svconfigurator.core.IService;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Project
extends AbstractProjectElement
implements IProject {
    private Set<IService> services = new HashSet<IService>();
    private URL serverUrl;

    public Project(String id, String name, String projectPassword, URL serverUrl, IProjectElementDataSource ds) {
        super(id, name, ds);
        this.serverUrl = serverUrl;
    }

    public String toString() {
        return "Project[" + this.getName() + "]";
    }

    @Override
    public void accept(IProjectElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Collection<IService> getServices() {
        return this.services;
    }

    @Override
    public void addService(IService svc) {
        this.services.add(svc);
        svc.setBaseProject(this);
    }

    @Override
    public URL getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getProjectPassword() {
        return this.projectPassword;
    }
}

