/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl.base;

import com.microfocus.sv.svconfigurator.cli.impl.base.CliCommandProcessorBase;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutorFactory;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public abstract class CliServerCommandProcessorBase
extends CliCommandProcessorBase {
    public CliServerCommandProcessorBase(String command) {
        super(command);
    }

    @Override
    protected void addCommandLineOptions(Options options) {
        super.addCommandLineOptions(options);
        CliUtils.addConnectionOptions(options);
    }

    @Override
    protected final int execute(final CommandLine parameters) {
        try {
            if (!this.initParameters(parameters)) {
                this.printHelp();
                return 1000;
            }
            List<Server> servers = CliUtils.obtainServers(parameters, null, true);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.createCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    CliServerCommandProcessorBase.this.executeWithServerExecutor(parameters, executor);
                }
            });
        }
        catch (AbstractSVCException e) {
            this.log.error(e.getLocalizedMessage(), e);
            return 1500;
        }
        return 0;
    }

    protected boolean initParameters(CommandLine parameters) {
        return true;
    }

    protected abstract int executeWithServerExecutor(CommandLine var1, ICommandExecutor var2) throws AbstractSVCException;

    protected ICommandExecutorFactory createCommandExecutorFactory() {
        return new CommandExecutorFactory();
    }
}

