/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.IListProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCLICommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    public static final String COMMAND = "list";
    private static final String HELP_USAGE = "list [parameters]";
    private static final Logger LOG = LoggerFactory.getLogger(ListCLICommandProcessor.class);
    private IListProcessor processor;
    private Options opts;

    public ListCLICommandProcessor(IProjectBuilder projectBuilder, IListProcessor processor) {
        super(projectBuilder);
        this.processor = processor;
        this.opts = this.createPropsOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            final IProject proj = this.getProject(line);
            List<Server> servers = CliUtils.obtainServers(line, null, true);
            final String outputFormat = CliUtils.obtainOutputFormat(line);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.processor.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    ListCLICommandProcessor.this.processor.process(proj, outputFormat, executor);
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), e);
            CliUtils.printHelp(HELP_USAGE, this.opts, null);
            return 1000;
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage(), e);
            CliUtils.printHelp(HELP_USAGE, this.opts, null);
            return 1000;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1100;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1200;
        }
        catch (CommandExecutorException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1300;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1500;
        }
        return 0;
    }

    private Options createPropsOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption("p", "project", true, "Specify this property (.vproj or .vproja file) either if you want to list only those services on SA server that are in the project (filtering) or if you want to use the server management URL from the project. If you don't specify the project file all services on the server will be printed.");
        opts.addOption("w", "project-password", true, "Project encryption password");
        CliUtils.addOutputFormatOptions(opts);
        return opts;
    }
}

