/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.DeployProcessorInput;
import com.microfocus.sv.svconfigurator.processor.IDeployProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployCLICommandProcessor
extends AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    public static final String COMMAND = "deployProject";
    private static final String MANDAT_PROP_PROJ = "project_file";
    private static final String HELP_USAGE = "deployProject [parameters] <project_file>";
    private static final String PARAM_FORCE = "f";
    private static final String LONG_PARAM_FORCE = "force";
    private static final String PARAM_UNDEPLOY = "u";
    private static final String LONG_PARAM_UNDEPLOY = "undeploy";
    private static final String PARAM_SERVICE = "s";
    private static final String LONG_PARAM_SERVICE = "service";
    private static final String LONG_PARAM_FIRST_AGENT_FALLBACK = "first-agent-fallback";
    private static final String LONG_PARAM_AGENT_REMAPPING = "remap";
    private static final Logger LOG = LoggerFactory.getLogger(DeployCLICommandProcessor.class);
    private IDeployProcessor deployProcessor;
    private Options opts;

    public DeployCLICommandProcessor(IProjectBuilder projectBuilder, IDeployProcessor deployProcessor) {
        super(projectBuilder);
        this.deployProcessor = deployProcessor;
        this.opts = this.createParamOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            IProject proj = this.getProject(line);
            if (proj == null) {
                throw new ParseException("You have to specify the project.");
            }
            List<Server> servers = CliUtils.obtainServers(line, proj);
            boolean force = line.hasOption(PARAM_FORCE);
            boolean undeploy = line.hasOption(PARAM_UNDEPLOY);
            String svc = line.hasOption(PARAM_SERVICE) ? line.getOptionValue(PARAM_SERVICE) : null;
            Map<String, String> agentRemapping = this.getAgentRemapping(line);
            boolean importLoggedMessages = line.hasOption("with-logged-messages");
            final DeployProcessorInput input = new DeployProcessorInput(force, undeploy, proj, svc, agentRemapping, importLoggedMessages);
            input.setFirstAgentFailover(line.hasOption(LONG_PARAM_FIRST_AGENT_FALLBACK));
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.deployProcessor.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    DeployCLICommandProcessor.this.deployProcessor.process(input, executor);
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), e);
            CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandatParamOptions());
            return 1000;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1100;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1200;
        }
        catch (CommandExecutorException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1300;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), e);
            return 1500;
        }
        return 0;
    }

    private Options createParamOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PARAM_FORCE, LONG_PARAM_FORCE, false, "Force the deployment. This parameter is used when the service that we want to deployProject is locked by another user. Force mode overrides the lock.");
        opts.addOption(PARAM_UNDEPLOY, LONG_PARAM_UNDEPLOY, false, "Undeploys all the services from the project.");
        opts.addOption(PARAM_SERVICE, LONG_PARAM_SERVICE, true, "If you specify this parameter, only the specified service will be deployed.");
        opts.addOption("w", "project-password", true, "Project encryption password");
        opts.addOption(null, LONG_PARAM_FIRST_AGENT_FALLBACK, false, "When there is no such an agent on the server The first one of the same type will be automatically selected.");
        OptionBuilder.withArgName("vprojAgentID=serverAgentID");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("This optional parameter allows remapping your project agents to server agents having different IDs (but same type). Use the parameter once for each agent remapped. Note that Agent ID is case sensitive.");
        Option agentRemappingProperty = OptionBuilder.create(LONG_PARAM_AGENT_REMAPPING);
        opts.addOption(agentRemappingProperty);
        opts.addOption(null, "with-logged-messages", false, "Import logged messages");
        return opts;
    }

    private Options createMandatParamOptions() {
        Options opts = new Options();
        opts.addOption(MANDAT_PROP_PROJ, false, "Project file (.vproj or .vproja) for the deployment.");
        return opts;
    }

    private Map<String, String> getAgentRemapping(CommandLine line) {
        HashMap<String, String> agentMapping = new HashMap<String, String>();
        if (line.hasOption(LONG_PARAM_AGENT_REMAPPING)) {
            Properties optionProperties = line.getOptionProperties(LONG_PARAM_AGENT_REMAPPING);
            for (String propertyName : optionProperties.stringPropertyNames()) {
                agentMapping.put(propertyName, optionProperties.getProperty(propertyName));
            }
        }
        return !agentMapping.isEmpty() ? agentMapping : null;
    }
}

