/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.build.ManifestProcessor;
import com.microfocus.sv.svconfigurator.build.parser.AbstractProjectElementParser;
import com.microfocus.sv.svconfigurator.core.IContentFile;
import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IDataSet;
import com.microfocus.sv.svconfigurator.core.ILoggedServiceCallList;
import com.microfocus.sv.svconfigurator.core.IManifest;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.IServiceDescription;
import com.microfocus.sv.svconfigurator.core.impl.datasource.ArchiveProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.datasource.ContentFileElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.datasource.FileProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.visitor.DataSetFilter;
import com.microfocus.sv.svconfigurator.core.impl.visitor.ProjectVisitorAdapter;
import com.microfocus.sv.svconfigurator.core.impl.visitor.ServiceChildElementFilter;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectBuilder
implements IProjectBuilder {
    private final String ERROR_CONTENT_FILE_PARSING = "Error when parsing content file project items";
    public static final String VPROJA_SUFFIX = ".vproja";
    public static final String VPROJ_SUFFIX = ".vproj";
    private static final Logger LOG = LoggerFactory.getLogger(ProjectBuilder.class);

    @Override
    public IProject buildProject(File projFile, String projectPassword) throws ProjectBuilderException {
        Collection<IProjectElementDataSource> dataSources = this.getDataSources(projFile, projectPassword);
        Map<String, IProjectElement> entityMap = this.createEntityIdFileNameMap(dataSources, projectPassword);
        ManifestProjectGrabber grabber = new ManifestProjectGrabber();
        for (IProjectElement el : entityMap.values()) {
            el.accept(grabber);
        }
        IProject p = grabber.getProject();
        for (IManifest m : grabber.getManifests()) {
            IService svc = this.processManifest(m, entityMap);
            p.addService(svc);
        }
        return p;
    }

    @Override
    public Collection<IProjectElementDataSource> getDataSources(File projFile, String projectPassword) throws ProjectBuilderException {
        String fileName = projFile.getAbsolutePath();
        if (!projFile.exists()) {
            throw new ProjectBuilderException("File \"" + fileName + "\" was not found.");
        }
        if (fileName.endsWith(VPROJ_SUFFIX)) {
            return this.obtainProjectDataSources(projFile);
        }
        if (fileName.endsWith(VPROJA_SUFFIX)) {
            return this.obtainProjectArchiveDataSources(projFile, projectPassword);
        }
        throw new ProjectBuilderException("Unknown project file: " + fileName);
    }

    private Collection<IProjectElementDataSource> obtainProjectDataSources(File proj) throws ProjectBuilderException {
        try {
            File[] msgLogs;
            HashSet<IProjectElementDataSource> res = new HashSet<IProjectElementDataSource>();
            FileInputStream fis = new FileInputStream(proj);
            res.add(new FileProjectElementDataSource(proj));
            File parent = proj.getParentFile();
            NodeList childNodes = this.getProjectItems(fis);
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node projectFileNode = childNodes.item(i);
                String projectFilePath = projectFileNode.getAttributes().getNamedItem("Include").getTextContent();
                File f = new File(parent, projectFilePath);
                if (!f.exists()) {
                    throw new ProjectBuilderException("File " + f.getName() + " was not found.");
                }
                if (projectFileNode.getLocalName() == "None") {
                    res.add(new FileProjectElementDataSource(f));
                }
                if (projectFileNode.getLocalName() != "Content") continue;
                res.add(new ContentFileElementDataSource(new FileProjectElementDataSource(f), XmlUtils.getNodeAsKeyValueMap(childNodes.item(i), (short)1)));
            }
            for (File msgLogFile : msgLogs = proj.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".msglog");
                }
            })) {
                res.add(new FileProjectElementDataSource(msgLogFile));
            }
            return res;
        }
        catch (FileNotFoundException e) {
            throw new ProjectBuilderException("Project file was not found", e);
        }
        catch (ParserConfigurationException e) {
            throw new ProjectBuilderException("Error when parsing content file project items", e);
        }
        catch (TransformerException e) {
            throw new ProjectBuilderException("Error when parsing content file project items", e);
        }
        catch (IOException e) {
            throw new ProjectBuilderException("Error when parsing content file project items", e);
        }
    }

    private Collection<IProjectElementDataSource> obtainProjectArchiveDataSources(File archive, String projectPassword) throws ProjectBuilderException {
        HashSet<IProjectElementDataSource> res = new HashSet<IProjectElementDataSource>();
        try {
            ZipFile zipFile = new ZipFile(archive);
            if (zipFile.isEncrypted()) {
                if (projectPassword == null || projectPassword.length() == 0) {
                    throw new ProjectBuilderException("Project archive '" + archive.getAbsolutePath() + "' is encrypted but project password is not specified");
                }
                zipFile.setPassword(projectPassword);
            }
            FileHeader proj = null;
            for (Object o : zipFile.getFileHeaders()) {
                FileHeader fileHeader = (FileHeader)o;
                if (!fileHeader.getFileName().endsWith(VPROJ_SUFFIX)) continue;
                proj = fileHeader;
                break;
            }
            if (proj == null) {
                throw new ProjectBuilderException(".vproj file was not found in the project archive");
            }
            res.add(new ArchiveProjectElementDataSource(zipFile, proj));
            NodeList childNodes = this.getProjectItems(zipFile.getInputStream(proj));
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node projectFileNode = childNodes.item(i);
                String projectFilePath = projectFileNode.getAttributes().getNamedItem("Include").getTextContent();
                FileHeader entry = zipFile.getFileHeader(projectFilePath);
                if (entry == null) {
                    throw new ProjectBuilderException(projectFilePath + " file was not found in project archive.");
                }
                if (projectFileNode.getLocalName() == "None") {
                    res.add(new ArchiveProjectElementDataSource(zipFile, entry));
                }
                if (projectFileNode.getLocalName() != "Content") continue;
                res.add(new ContentFileElementDataSource(new ArchiveProjectElementDataSource(zipFile, entry), XmlUtils.getNodeAsKeyValueMap(childNodes.item(i), (short)1)));
            }
            for (Object o : zipFile.getFileHeaders()) {
                FileHeader fileHeader = (FileHeader)o;
                if (!fileHeader.getFileName().endsWith(".msglog")) continue;
                res.add(new ArchiveProjectElementDataSource(zipFile, fileHeader));
            }
            return res;
        }
        catch (ZipException e) {
            throw new ProjectBuilderException("Project Archive File processing exception.", e);
        }
        catch (TransformerException e) {
            throw new ProjectBuilderException("Error when parsing content file project items", e);
        }
        catch (IOException e) {
            throw new ProjectBuilderException("Error when parsing content file project items", e);
        }
        catch (ParserConfigurationException e) {
            throw new ProjectBuilderException("Error when parsing content file project items", e);
        }
    }

    private NodeList getProjectItems(InputStream is) throws ProjectBuilderException {
        try {
            Document doc = XmlUtils.createDoc(is);
            return XmlUtils.evalNodeListXpath("//*[local-name()='None' or local-name()='Content']", doc);
        }
        catch (IOException e) {
            throw new ProjectBuilderException(e.getMessage(), e);
        }
        catch (SVCParseException e) {
            throw new ProjectBuilderException(e.getMessage(), e);
        }
        catch (XPathExpressionException e) {
            throw new ProjectBuilderException(e.getMessage(), e);
        }
    }

    private IService processManifest(IManifest m, Map<String, IProjectElement> entities) throws ProjectBuilderException {
        ManifestProcessor mp = new ManifestProcessor(entities, m);
        IService svc = mp.getRoot();
        ServiceChildElementFilter svcChildFilter = new ServiceChildElementFilter();
        for (IProjectElement el : mp.getChildrenForElement(svc)) {
            el.accept(svcChildFilter);
        }
        for (IDataModel dm : svcChildFilter.getDataModels()) {
            DataSetFilter dsFilter = new DataSetFilter();
            for (IProjectElement ch : mp.getChildrenForElement(dm)) {
                ch.accept(dsFilter);
                ch.accept(svcChildFilter);
            }
            for (IDataSet ds : dsFilter.getDataSets()) {
                dm.addDataSet(ds);
            }
            svc.addDataModel(dm);
        }
        for (IPerfModel pm : svcChildFilter.getPerfModels()) {
            svc.addPerfModel(pm);
        }
        for (IServiceDescription sd : svcChildFilter.getSvcDescriptions()) {
            svc.addDescription(sd);
        }
        for (IContentFile cf : svcChildFilter.getSvcContentFiles()) {
            svc.addContentFile(cf);
        }
        for (ILoggedServiceCallList lscl : svcChildFilter.getLoggedServiceCallLists()) {
            svc.addLoggedServiceCallList(lscl);
        }
        return svc;
    }

    private Map<String, IProjectElement> createEntityIdFileNameMap(Collection<IProjectElementDataSource> dataSources, String projectPassword) throws ProjectBuilderException {
        HashMap<String, IProjectElement> res = new HashMap<String, IProjectElement>();
        for (IProjectElementDataSource ds : dataSources) {
            try {
                AbstractProjectElementParser parser = AbstractProjectElementParser.getParserForDataSource(ds);
                IProjectElement element = parser.create(ds, projectPassword);
                res.put(element.getId(), element);
            }
            catch (SVCParseException e) {
                throw new ProjectBuilderException(String.format("Error during entry parse phase (%s).", e.getMessage()), e);
            }
        }
        return res;
    }

    private static class ManifestProjectGrabber
    extends ProjectVisitorAdapter {
        private IProject p = null;
        private Set<IManifest> manifests = new HashSet<IManifest>();

        private ManifestProjectGrabber() {
        }

        @Override
        public void visit(IProject p) {
            this.p = p;
        }

        @Override
        public void visit(IManifest m) {
            this.manifests.add(m);
        }

        public Collection<IManifest> getManifests() {
            return this.manifests;
        }

        public IProject getProject() {
            return this.p;
        }
    }
}

