/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessor;
import com.microfocus.sv.svconfigurator.processor.UndeployProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutorFactory;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UndeployTask
extends Task {
    private boolean force = false;
    private String service;
    private File projectFile;
    private String projectPassword;
    private String username;
    private String password;
    private String url;
    private boolean trustEveryone = false;

    public void execute() throws BuildException {
        this.validateData();
        IProject proj = this.projectFile == null ? null : AntTaskUtil.createProject(this.projectFile, this.projectPassword);
        Credentials credentials = ProjectUtils.createCredentials(this.username, this.password);
        URL uri = AntTaskUtil.createUri(this.url, proj);
        try {
            UndeployProcessor proc = new UndeployProcessor(new CommandExecutorFactory());
            UndeployProcessorInput input = new UndeployProcessorInput(this.force, proj, this.service);
            proc.process(input, proc.getCommandExecutorFactory().createCommandExecutor(uri, this.trustEveryone, credentials));
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CommandExecutorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validateData() throws BuildException {
        if (this.service == null && this.projectFile == null) {
            throw new BuildException("Either a service or a project has to be specified.");
        }
        if (this.url == null) {
            throw new BuildException("SV Server management URL have to be specified.");
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }
}

