/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.HotSwapProcessor;
import com.microfocus.sv.svconfigurator.processor.HotSwapProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutorFactory;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class HotSwapTask
extends Task {
    private boolean force = false;
    private String pm;
    private String service;
    private String username;
    private String password;
    private String url;
    private boolean trustEveryone = false;

    public void execute() throws BuildException {
        this.validateData();
        Credentials credentials = ProjectUtils.createCredentials(this.username, this.password);
        URL uri = AntTaskUtil.createUri(this.url, null);
        try {
            HotSwapProcessor proc = new HotSwapProcessor(new CommandExecutorFactory());
            HotSwapProcessorInput input = new HotSwapProcessorInput(this.force, this.service, this.pm);
            proc.process(input, proc.getCommandExecutorFactory().createCommandExecutor(uri, this.trustEveryone, credentials));
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CommandExecutorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validateData() throws BuildException {
        if (this.service == null) {
            throw new BuildException("Service identification (service) has to be specified.");
        }
        if (this.url == null) {
            throw new BuildException("SV Server management URL have to be specified.");
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setPm(String pm) {
        this.pm = pm;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }
}

