/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutor;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.HttpUtils;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DeployTask
extends Task {
    private File projectFile;
    private String projectPassword;
    private boolean force;
    private boolean undeploy = false;
    private String url;
    private boolean trustEveryone = false;
    private String username;
    private String password;
    private String service;

    public void execute() throws BuildException {
        this.validateData();
        IProject proj = AntTaskUtil.createProject(this.projectFile, this.projectPassword);
        Credentials credentials = ProjectUtils.createCredentials(this.username, this.password);
        URL uri = AntTaskUtil.createUri(this.url, proj);
        try {
            CommandExecutor exec = new CommandExecutor(HttpUtils.createServerManagementEndpointClient(uri, this.trustEveryone, credentials));
            exec.setForce(this.force);
            IService svc = null;
            if (this.service != null) {
                svc = ProjectUtils.findProjElem(proj.getServices(), this.service, "Virtual service");
            }
            if (this.undeploy) {
                if (svc == null) {
                    exec.undeploy(proj);
                } else {
                    exec.undeployService(svc);
                }
            } else if (svc == null) {
                exec.deployProject(proj);
            } else {
                exec.deployService(svc, proj.getProjectPassword());
            }
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CommandExecutorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validateData() throws BuildException {
        if (this.projectFile == null) {
            throw new BuildException("Project File (projectFile) has to be specified.");
        }
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUndeploy(boolean undeploy) {
        this.undeploy = undeploy;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }
}

