/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator;

import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Global {
    private static final Logger LOG = LoggerFactory.getLogger(Global.class);

    public static synchronized String getClientId(ICommandExecutor executor) {
        String username;
        String creds = executor.getClient().getClient().getUsername();
        String clientHost = Global.getClientHost();
        if (creds != null && "https".equals(executor.getClient().getMgmtUri().getProtocol())) {
            String serverHost = Global.getServerHost(executor);
            username = creds + "/" + serverHost;
        } else {
            username = System.getProperty("user.name");
        }
        String res = username.toLowerCase() + "@" + clientHost.toLowerCase() + "/SVConfigurator";
        return Normalizer.normalize(res, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    private static String getClientHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.debug(e.toString(), e);
            return "unknown";
        }
    }

    private static String getServerHost(ICommandExecutor executor) {
        try {
            String id = executor.getClient().getServerInfo().getId();
            String host = id.contains(":") ? new URL(id).getHost() : id;
            return host.split("\\.", 2)[0];
        }
        catch (Exception e) {
            return executor.getClient().getMgmtUri().getHost();
        }
    }
}

