/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.adm.performancecenter.plugins.common.utils;

import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestPlanFolder;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestPlanFolders;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.common.Common;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Helper {
    public static XStream xstreamPermissions(XStream xstream) {
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypesByWildcard(new String[]{"com.microfocus.adm.performancecenter.plugins.common.pcentities.**"});
        xstream.ignoreUnknownElements();
        return xstream;
    }

    public static ArrayList<String[]> getCleanAndNonExistingAndSortedArrayList(ArrayList<String[]> pathFromSubjectAndFolders, PcTestPlanFolders pcTestPlanFolders) throws IOException, PcException {
        ArrayList<String[]> pathFromSubjectAndFoldersFiltered = new ArrayList<String[]>();
        for (String[] pathFromSubjectAndFolder : pathFromSubjectAndFolders) {
            String fullpath = pathFromSubjectAndFolder[0] + '\\' + pathFromSubjectAndFolder[1];
            boolean exist = false;
            if (pcTestPlanFolders == null) continue;
            for (PcTestPlanFolder pcTestPlanFolder : pcTestPlanFolders.getPcTestPlanFolderList()) {
                if (!pcTestPlanFolder.getFullPath().equalsIgnoreCase(fullpath)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            pathFromSubjectAndFoldersFiltered.add(pathFromSubjectAndFolder);
        }
        Collections.sort(pathFromSubjectAndFoldersFiltered, new Comparator<String[]>(){

            @Override
            public int compare(String[] strings, String[] otherStrings) {
                return strings[0].compareTo(otherStrings[0]);
            }
        });
        return pathFromSubjectAndFoldersFiltered;
    }

    public static ArrayList<String[]> getArrayListOfStringArray(String[] paths) {
        ArrayList<String[]> pathFromSubjectAndFolders = new ArrayList<String[]>();
        for (String path : paths) {
            List<String> folders = Arrays.asList(path.split("\\\\"));
            for (int i = 1; i < folders.size(); ++i) {
                String pathFromSubject = Helper.join("\\", folders.subList(0, i));
                String folder = folders.get(i);
                String[] pathFromSubjectAndFolder = new String[]{pathFromSubject, folder};
                if (Helper.IsArrayExistInArrayList(pathFromSubjectAndFolders, pathFromSubjectAndFolder)) continue;
                pathFromSubjectAndFolders.add(pathFromSubjectAndFolder);
            }
        }
        return pathFromSubjectAndFolders;
    }

    private static boolean IsArrayExistInArrayList(ArrayList<String[]> arrayList, String[] arrayToVerify) {
        for (Object[] objectArray : arrayList) {
            if (!Arrays.equals(objectArray, arrayToVerify)) continue;
            return true;
        }
        return false;
    }

    public static String join(CharSequence delimiter, List<String> tokens) {
        int length = tokens.size();
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.get(0));
        for (int i = 1; i < length; ++i) {
            sb.append(delimiter);
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }

    public static String[] GetLreServerAndTenant(String lreServer) {
        String delimiterSlash = "/";
        String delimiterQuestionMark = "\\?";
        String useDelimiter = delimiterSlash;
        String[] strServerAndTenant = new String[]{lreServer, ""};
        String theLreServer = lreServer;
        if (lreServer != null && !lreServer.isEmpty()) {
            theLreServer = lreServer.toLowerCase().replace("http://", "");
            theLreServer = theLreServer.replace("https://", "");
            theLreServer = theLreServer.replace("/lre", "");
            theLreServer = theLreServer.replace("/site", "");
            theLreServer = theLreServer.replace("/loadtest", "");
            theLreServer = theLreServer.replace("/pcx", "");
            theLreServer = theLreServer.replace("/adminx", "");
            theLreServer = theLreServer.replace("/admin", "");
            theLreServer = theLreServer.replace("/login", "");
        }
        if (theLreServer != null && !theLreServer.isEmpty()) {
            if (theLreServer.contains("/")) {
                useDelimiter = delimiterSlash;
            } else if (theLreServer.contains("?")) {
                useDelimiter = delimiterQuestionMark;
            }
            String[] severTenantArray = theLreServer.split(useDelimiter);
            if (severTenantArray.length > 0) {
                strServerAndTenant[0] = severTenantArray[0];
                if (severTenantArray.length > 1) {
                    strServerAndTenant[1] = useDelimiter.equals(delimiterQuestionMark) ? delimiterQuestionMark + severTenantArray[1] : severTenantArray[1];
                }
            }
        }
        return strServerAndTenant;
    }

    public static int extractTestIdFromString(String value) {
        Pattern pattern;
        Matcher matcher;
        if (value != null && !value.isEmpty() && (matcher = (pattern = Pattern.compile("ID:'([^']*)'")).matcher(value)).find()) {
            return Common.stringToInteger(matcher.group(1));
        }
        return 0;
    }

    public static Path getParent(Path path) {
        if (path.getParent() != null) {
            return path.getParent();
        }
        return Paths.get(Helper.getParent(path.toString()), new String[0]);
    }

    public static String getName(String strPath) {
        char chrSeparatorBackward = '\\';
        char chrSeparatorForward = '/';
        String strPathToHandle = strPath;
        if (strPathToHandle == null || strPathToHandle.isEmpty() || strPathToHandle.indexOf(chrSeparatorBackward) == -1 && strPathToHandle.indexOf(chrSeparatorForward) == -1) {
            return strPathToHandle;
        }
        if (strPathToHandle.indexOf(chrSeparatorForward) != -1) {
            strPathToHandle = strPathToHandle.replace(chrSeparatorForward, chrSeparatorBackward);
        }
        if (strPathToHandle.endsWith(String.valueOf(chrSeparatorBackward))) {
            strPathToHandle = strPathToHandle.replaceAll("\\$", "");
        }
        int index = strPathToHandle.lastIndexOf(chrSeparatorBackward);
        strPathToHandle = strPathToHandle.substring(index + 1);
        return strPathToHandle;
    }

    private static String getParent(String strPath) {
        char chrSeparatorBackward = '\\';
        char chrSeparatorForward = '/';
        String strPathToHandle = strPath;
        if (strPathToHandle == null || strPathToHandle.isEmpty() || strPathToHandle.indexOf(chrSeparatorBackward) == -1 && strPathToHandle.indexOf(chrSeparatorForward) == -1) {
            return "";
        }
        if (strPathToHandle.indexOf(chrSeparatorForward) != -1) {
            strPathToHandle = strPathToHandle.replace(chrSeparatorForward, chrSeparatorBackward);
        }
        if (strPathToHandle.endsWith(String.valueOf(chrSeparatorBackward))) {
            strPathToHandle = strPathToHandle.replaceAll("\\$", "");
        }
        int index = strPathToHandle.lastIndexOf(chrSeparatorBackward);
        strPathToHandle = strPathToHandle.substring(0, index);
        return strPathToHandle;
    }
}

