/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.adm.performancecenter.plugins.common.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.AuthenticationClient;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcErrorResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLog;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResults;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcScript;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcScripts;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestData;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestInstances;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestPlanFolder;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestPlanFolders;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestSets;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTrendReportMetaData;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTrendedRun;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.ReleaseTimeslot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.ScriptCreateRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TestInstanceCreateRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TestPlanFolderCreateRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.Timeslot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TimeslotDuration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.Timeslots;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTransactionDataRoot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.Test;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.Content;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.SimplifiedTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.SimplifiedContent;
import com.microfocus.adm.performancecenter.plugins.common.utils.Base64Encoder;
import com.microfocus.adm.performancecenter.plugins.common.utils.ConvertContentStringToTest;
import com.microfocus.adm.performancecenter.plugins.common.utils.Helper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.xml.sax.SAXException;

public class PcRestProxy {
    public static final String PC_API_XMLNS = "http://www.hp.com/PC/REST/API";
    protected static final String BASE_PC_API_URL = "%s://%s/LoadTest/rest";
    protected static final String BASE_PC_API_AUTHENTICATION_URL = "%s://%s/LoadTest/rest/authentication-point";
    protected static final String AUTHENTICATION_LOGIN_URL = "%s://%s/LoadTest/rest/authentication-point/authenticate";
    protected static final String AUTHENTICATION_WITH_TOKEN_LOGIN_URL = "%s://%s/LoadTest/rest/authentication-point/authenticateclient";
    protected static final String AUTHENTICATION_LOGOUT_URL = "%s://%s/LoadTest/rest/authentication-point/logout";
    protected static final String PC_API_RESOURCES_TEMPLATE = "%s://%s/LoadTest/rest/domains/%s/projects/%s";
    protected static final String RUNS_RESOURCE_NAME = "Runs";
    protected static final String TESTS_RESOURCE_NAME = "tests";
    protected static final String TEST_INSTANCES_NAME = "testinstances";
    protected static final String TEST_SETS_NAME = "testsets";
    protected static final String RESULTS_RESOURCE_NAME = "Results";
    protected static final String EVENTLOG_RESOURCE_NAME = "EventLog";
    protected static final String TREND_REPORT_RESOURCE_NAME = "TrendReports";
    protected static final String TREND_REPORT_RESOURCE_SUFFIX = "data";
    protected static final String CONTENT_TYPE_XML = "application/xml";
    protected static final String SCRIPTS_RESOURCE_NAME = "Scripts";
    protected static final String TESTPLAN_RESOURCE_NAME = "testplan";
    protected static final String TIMESLOTS = "timeslots";
    protected static final List<Integer> validStatusCodes = Arrays.asList(200, 201, 202, 204);
    private String baseURL;
    private String pcServer;
    private String domain;
    private String project;
    private String webProtocol;
    private String proxyScheme;
    private String proxyHostName;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private DefaultHttpClient client;
    private HttpContext context;
    private CookieStore cookieStore;
    private String tenantSuffix;
    private boolean authenticateWithToken;

    public PcRestProxy(String webProtocolName, String pcServerName, boolean authenticateWithToken, String almDomain, String almProject, String proxyOutURL, String proxyUser, String proxyPassword) throws PcException {
        String[] lreServerAndTenant = Helper.GetLreServerAndTenant(pcServerName);
        this.pcServer = lreServerAndTenant[0];
        this.tenantSuffix = lreServerAndTenant[1];
        this.domain = almDomain;
        this.project = almProject;
        this.webProtocol = webProtocolName;
        this.baseURL = String.format(PC_API_RESOURCES_TEMPLATE, this.webProtocol, this.pcServer, this.domain, this.project);
        this.authenticateWithToken = authenticateWithToken;
        PoolingClientConnectionManager cxMgr = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault());
        cxMgr.setMaxTotal(100);
        cxMgr.setDefaultMaxPerRoute(20);
        this.client = new DefaultHttpClient(cxMgr);
        if (proxyOutURL != null && !proxyOutURL.isEmpty()) {
            this.getProxyDataFromURL(proxyOutURL);
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            HttpHost proxy = new HttpHost(this.proxyHostName, this.proxyPort, this.proxyScheme);
            if (proxyUser != null && !proxyUser.isEmpty()) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                AuthScope authScope = new AuthScope(this.proxyHostName, this.proxyPort);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                this.client.getCredentialsProvider().setCredentials(authScope, credentials);
            }
            this.client.getParams().setParameter("http.route.default-proxy", proxy);
        }
        this.context = new BasicHttpContext();
        this.cookieStore = new BasicCookieStore();
        this.context.setAttribute("http.cookie-store", this.cookieStore);
    }

    public static Content getContentFromXmlOrYamlString(String xmlOrYamlTest) {
        Content content = null;
        try {
            Test test = Test.xmlToObject(xmlOrYamlTest);
            content = test.getContent();
        }
        catch (Exception ex) {
            content = Content.xmlToObject(xmlOrYamlTest);
        }
        return content;
    }

    public static boolean isOk(HttpResponse response) {
        return validStatusCodes.contains(response.getStatusLine().getStatusCode());
    }

    public static SimplifiedContent xmlOrYamlStringToSimplifiedContent(String strSimplifiedContent) throws IOException {
        SimplifiedContent simplifiedContent;
        if (strSimplifiedContent == null || strSimplifiedContent.isEmpty()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            simplifiedContent = mapper.readValue(strSimplifiedContent, SimplifiedContent.class);
        }
        catch (Exception ex1) {
            try {
                simplifiedContent = SimplifiedContent.xmlToObject(strSimplifiedContent);
            }
            catch (Exception ex2) {
                throw ex1;
            }
        }
        return simplifiedContent;
    }

    public static SimplifiedTest xmlOrYamlStringToSimplifiedTest(String strSimplifiedTest) throws IOException {
        SimplifiedTest simplifiedTest;
        if (strSimplifiedTest == null || strSimplifiedTest.isEmpty()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            simplifiedTest = mapper.readValue(strSimplifiedTest, SimplifiedTest.class);
        }
        catch (Exception ex1) {
            try {
                simplifiedTest = SimplifiedTest.xmlToObject(strSimplifiedTest);
            }
            catch (Exception ex2) {
                throw ex1;
            }
        }
        return simplifiedTest;
    }

    private void getProxyDataFromURL(String proxyURL) throws PcException {
        try {
            String mainStr = "";
            if (proxyURL != null && !proxyURL.isEmpty()) {
                String[] urlSplit = proxyURL.split("://");
                this.proxyScheme = urlSplit[0];
                mainStr = urlSplit[1];
                if (mainStr.contains(":")) {
                    this.proxyHostName = mainStr.split(":")[0];
                    this.proxyPort = Integer.parseInt(mainStr.split(":")[1]);
                } else {
                    this.proxyHostName = mainStr;
                    this.proxyPort = 80;
                }
            }
        }
        catch (Exception ex) {
            throw new PcException("Error: Validating Proxy URL: " + ex + " Please add a proxy URL in this pattern: http(s)://<host>:<port> or leave blank");
        }
    }

    public boolean authenticate(String userName, String password) throws PcException, ClientProtocolException, IOException {
        if (this.authenticateWithToken) {
            return this.authenticateWithToken(userName, password);
        }
        return this.authenticateWithoutToken(userName, password);
    }

    private boolean authenticateWithoutToken(String userName, String password) throws PcException, ClientProtocolException, IOException {
        String userNameAndPassword = userName + ":" + password;
        String encodedCredentials = Base64Encoder.encode(userNameAndPassword.getBytes());
        HttpGet authRequest = new HttpGet(String.format(AUTHENTICATION_LOGIN_URL + this.tenantSuffix, this.webProtocol, this.pcServer));
        authRequest.addHeader("Authorization", String.format("Basic %s", encodedCredentials));
        this.executeRequest(authRequest);
        return true;
    }

    private boolean authenticateWithToken(String idKey, String secretkey) throws PcException, ClientProtocolException, IOException {
        AuthenticationClient authenticationClient = new AuthenticationClient(idKey, secretkey);
        HttpPost authRequestWithToken = new HttpPost(String.format(AUTHENTICATION_WITH_TOKEN_LOGIN_URL + this.tenantSuffix, this.webProtocol, this.pcServer));
        authRequestWithToken.addHeader("Content-Type", CONTENT_TYPE_XML);
        authRequestWithToken.setEntity(new StringEntity(authenticationClient.objectToXML(), ContentType.APPLICATION_XML));
        this.executeRequest(authRequestWithToken);
        return true;
    }

    public PcRunResponse startRun(int testId, int testInstanceId, TimeslotDuration timeslotDuration, String postRunAction, boolean vudsMode, int timeslot) throws PcException, ClientProtocolException, IOException {
        HttpPost startRunRequest = new HttpPost(String.format(this.baseURL + "/%s", RUNS_RESOURCE_NAME));
        startRunRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        PcRunRequest runRequestData = new PcRunRequest(testId, testInstanceId, timeslot, timeslotDuration, postRunAction, vudsMode);
        startRunRequest.setEntity(new StringEntity(runRequestData.objectToXML(), ContentType.APPLICATION_XML));
        HttpResponse response = this.executeRequest(startRunRequest);
        String startRunResponse = IOUtils.toString(response.getEntity().getContent());
        return PcRunResponse.xmlToObject(startRunResponse);
    }

    public int createTestInstance(int testId, int testSetId) throws PcException, ClientProtocolException, IOException {
        HttpPost createTestInstanceRequest = new HttpPost(String.format(this.baseURL + "/%s", TEST_INSTANCES_NAME));
        TestInstanceCreateRequest testInstanceCreateRequest = new TestInstanceCreateRequest(testId, testSetId);
        createTestInstanceRequest.setEntity(new StringEntity(testInstanceCreateRequest.objectToXML(), ContentType.APPLICATION_XML));
        createTestInstanceRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        HttpResponse response = this.executeRequest(createTestInstanceRequest);
        String responseXml = IOUtils.toString(response.getEntity().getContent());
        int testInstanceID = 0;
        try {
            testInstanceID = testInstanceCreateRequest.getTestInstanceIDFromResponse(responseXml, "TestInstanceID");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PcException("createTestInstance exception: " + e);
        }
        return testInstanceID;
    }

    public PcTestSets GetAllTestSets() throws IOException, PcException {
        String getTestSetsUrl = String.format(this.baseURL + "/%s", TEST_SETS_NAME);
        HttpGet getTestSetsRequest = new HttpGet(getTestSetsUrl);
        HttpResponse response = this.executeRequest(getTestSetsRequest);
        String testSets = IOUtils.toString(response.getEntity().getContent());
        return PcTestSets.xmlToObject(testSets);
    }

    public PcTestInstances getTestInstancesByTestId(int testId) throws PcException, IOException {
        String uri = String.format(this.baseURL + "/%s?%s=%s", TEST_INSTANCES_NAME, "query", URLEncoder.encode("{test-id[" + testId + "]}", "UTF-8"));
        HttpGet getFirtstTestInstanceByTestID = new HttpGet(uri);
        HttpResponse response = this.executeRequest(getFirtstTestInstanceByTestID);
        String testInstances = IOUtils.toString(response.getEntity().getContent());
        return PcTestInstances.xmlToObject(testInstances);
    }

    public boolean stopRun(int runId, String stopMode) throws PcException, ClientProtocolException, IOException {
        String stopUrl = String.format(this.baseURL + "/%s/%s/%s", RUNS_RESOURCE_NAME, runId, stopMode);
        HttpPost stopRunRequest = new HttpPost(stopUrl);
        ReleaseTimeslot releaseTimesloteRequest = new ReleaseTimeslot(true, "Do Not Collate");
        stopRunRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        stopRunRequest.setEntity(new StringEntity(releaseTimesloteRequest.objectToXML(), ContentType.APPLICATION_XML));
        this.executeRequest(stopRunRequest);
        return true;
    }

    public PcRunResponse getRunData(int runId) throws PcException, ClientProtocolException, IOException {
        HttpGet getRunDataRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", RUNS_RESOURCE_NAME, runId));
        HttpResponse response = this.executeRequest(getRunDataRequest);
        String runData = IOUtils.toString(response.getEntity().getContent());
        return PcRunResponse.xmlToObject(runData);
    }

    public PcTest getTestData(int testId) throws IOException, PcException {
        HttpGet getTestDataRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        HttpResponse response = this.executeRequest(getTestDataRequest);
        String testData = IOUtils.toString(response.getEntity().getContent());
        return PcTestData.xmlToObject(testData);
    }

    public PcRunResults getRunResults(int runId) throws PcException, ClientProtocolException, IOException {
        String getRunResultsUrl = String.format(this.baseURL + "/%s/%s/%s", RUNS_RESOURCE_NAME, runId, RESULTS_RESOURCE_NAME);
        HttpGet getRunResultsRequest = new HttpGet(getRunResultsUrl);
        HttpResponse response = this.executeRequest(getRunResultsRequest);
        String runResults = IOUtils.toString(response.getEntity().getContent());
        return PcRunResults.xmlToObject(runResults);
    }

    public boolean GetRunResultData(int runId, int resultId, String localFilePath) throws PcException, ClientProtocolException, IOException {
        String getRunResultDataUrl = String.format(this.baseURL + "/%s/%s/%s/%s/data", RUNS_RESOURCE_NAME, runId, RESULTS_RESOURCE_NAME, resultId);
        HttpGet getRunResultRequest = new HttpGet(getRunResultDataUrl);
        HttpResponse response = this.executeRequest(getRunResultRequest);
        FileOutputStream out = new FileOutputStream(localFilePath);
        InputStream in = response.getEntity().getContent();
        IOUtils.copy(in, (OutputStream)out);
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        return true;
    }

    public TrendReportTransactionDataRoot getTrendReportByXML(String trendReportId, int runId) throws PcException, ClientProtocolException, IOException {
        String getTrendReportByXMLUrl = String.format(this.baseURL + "/%s/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId, runId);
        HttpGet getTrendReportByXMLRequest = new HttpGet(getTrendReportByXMLUrl);
        HttpResponse response = this.executeRequest(getTrendReportByXMLRequest);
        String trendReportByXML = IOUtils.toString(response.getEntity().getContent(), "UTF-8");
        return TrendReportTransactionDataRoot.xmlToObject(trendReportByXML);
    }

    public boolean updateTrendReport(String trendReportId, TrendReportRequest trendReportRequest) throws PcException, IOException {
        String updateTrendReportUrl = String.format(this.baseURL + "/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId);
        HttpPost updateTrendReportRequest = new HttpPost(updateTrendReportUrl);
        updateTrendReportRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        updateTrendReportRequest.setEntity(new StringEntity(trendReportRequest.objectToXML(), ContentType.APPLICATION_XML));
        this.executeRequest(updateTrendReportRequest);
        return true;
    }

    public InputStream getTrendingPDF(String trendReportId) throws IOException, PcException {
        String getTrendReportUrl = String.format(this.baseURL + "/%s/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId, TREND_REPORT_RESOURCE_SUFFIX);
        HttpGet getTrendReportRequest = new HttpGet(getTrendReportUrl);
        this.executeRequest(getTrendReportRequest);
        HttpResponse response = this.executeRequest(getTrendReportRequest);
        InputStream in = response.getEntity().getContent();
        return in;
    }

    public ArrayList<PcTrendedRun> getTrendReportMetaData(String trendReportId) throws PcException, ClientProtocolException, IOException {
        String getTrendReportMetaDataUrl = String.format(this.baseURL + "/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId);
        HttpGet getTrendReportMetaDataRequest = new HttpGet(getTrendReportMetaDataUrl);
        HttpResponse response = this.executeRequest(getTrendReportMetaDataRequest);
        String trendReportMetaData = IOUtils.toString(response.getEntity().getContent());
        return PcTrendReportMetaData.xmlToObject(trendReportMetaData);
    }

    public PcRunEventLog getRunEventLog(int runId) throws PcException, ClientProtocolException, IOException {
        String getRunEventLogUrl = String.format(this.baseURL + "/%s/%s/%s", RUNS_RESOURCE_NAME, runId, EVENTLOG_RESOURCE_NAME);
        HttpGet getRunEventLogRequest = new HttpGet(getRunEventLogUrl);
        HttpResponse response = this.executeRequest(getRunEventLogRequest);
        String runEventLog = IOUtils.toString(response.getEntity().getContent());
        return PcRunEventLog.xmlToObject(runEventLog);
    }

    public Timeslots GetOpenTimeslotsByTestId(int testId) throws PcException, IOException {
        String uri = String.format(this.baseURL + "/%s?%s=%s", TIMESLOTS, "query", URLEncoder.encode("{LoadTestID[" + testId + "]}", "UTF-8"));
        HttpGet getTimeslotsByTestID = new HttpGet(uri);
        HttpResponse response = this.executeRequest(getTimeslotsByTestID);
        String allTimeslots = IOUtils.toString(response.getEntity().getContent());
        Timeslots timeslots = Timeslots.xmlToObject(allTimeslots);
        ArrayList<Timeslot> openedTimeslots = new ArrayList<Timeslot>(timeslots.getTimeslotsList().stream().filter(timeslot -> "open".equals(timeslot.getOpenStatus().toLowerCase())).collect(Collectors.toList()));
        timeslots.setTimeslotsList(openedTimeslots);
        return timeslots;
    }

    public boolean logout() throws PcException, ClientProtocolException, IOException {
        HttpGet logoutRequest = new HttpGet(String.format(AUTHENTICATION_LOGOUT_URL, this.webProtocol, this.pcServer));
        this.executeRequest(logoutRequest);
        return true;
    }

    protected HttpResponse executeRequest(HttpRequestBase request) throws PcException, IOException {
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
        if (!PcRestProxy.isOk(response)) {
            String message;
            try {
                String content = IOUtils.toString(response.getEntity().getContent());
                PcErrorResponse exception = PcErrorResponse.xmlToObject(content);
                message = String.format("%s Error code: %s", exception.getExceptionMessage(), exception.getErrorCode());
            }
            catch (Exception ex) {
                message = response.getStatusLine().toString();
            }
            throw new PcException("executeRequest exception: " + message);
        }
        return response;
    }

    public PcScripts getScripts() throws IOException, PcException {
        HttpGet getScriptsRequest = new HttpGet(String.format(this.baseURL + "/%s", SCRIPTS_RESOURCE_NAME));
        HttpResponse response = this.executeRequest(getScriptsRequest);
        String scripts = IOUtils.toString(response.getEntity().getContent());
        return PcScripts.xmlToObject(scripts);
    }

    public PcScript getScript(int Id2) throws IOException, PcException {
        HttpGet getScriptsRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", SCRIPTS_RESOURCE_NAME, Id2));
        HttpResponse response = this.executeRequest(getScriptsRequest);
        String script = IOUtils.toString(response.getEntity().getContent());
        return PcScript.xmlToObject(script);
    }

    public PcScript getScript(String testFolderPath, String scriptName) throws IOException, PcException {
        ArrayList<PcScript> pcScriptList = this.getScripts().getPcScriptList();
        for (PcScript pcScript : pcScriptList) {
            if (!pcScript.getTestFolderPath().equalsIgnoreCase(testFolderPath) || !pcScript.getName().equalsIgnoreCase(scriptName)) continue;
            return pcScript;
        }
        throw new PcException(String.format("No script named '%s' was found under this folder path '%s' within the PC project.", scriptName, testFolderPath));
    }

    public int uploadScript(String testFolderPath, boolean Overwrite, boolean RuntimeOnly, boolean KeepCheckedOut, String scriptPath) throws PcException, ClientProtocolException, IOException {
        this.createTestPlanFolder(testFolderPath);
        HttpPost createScriptRequest = new HttpPost(String.format(this.baseURL + "/%s", SCRIPTS_RESOURCE_NAME));
        File fileToSend = new File(scriptPath);
        FileInputStream FileInputStreamToSend = new FileInputStream(fileToSend);
        ScriptCreateRequest scriptCreateRequest = new ScriptCreateRequest(testFolderPath, Overwrite, RuntimeOnly, KeepCheckedOut);
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("File", new InputStreamBody((InputStream)FileInputStreamToSend, fileToSend.getName()));
        multipartEntity.addPart("Text", new StringBody(scriptCreateRequest.objectToXML()));
        createScriptRequest.setEntity(multipartEntity);
        HttpResponse response = this.executeRequest(createScriptRequest);
        String responseXml = IOUtils.toString(response.getEntity().getContent());
        int scriptID = 0;
        try {
            scriptID = scriptCreateRequest.getScriptIdFromResponse(responseXml, "ID");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PcException("uploadScript exception: " + e);
        }
        return scriptID;
    }

    public boolean deleteScript(int scriptId) throws PcException, ClientProtocolException, IOException {
        HttpDelete deleteRequest = new HttpDelete(String.format(this.baseURL + "/%s/%s", SCRIPTS_RESOURCE_NAME, scriptId));
        HttpResponse response = this.executeRequest(deleteRequest);
        return true;
    }

    public PcTestPlanFolders getTestPlanFolders() throws IOException, PcException {
        HttpGet getFolderTreeRequest = new HttpGet(String.format(this.baseURL + "/%s", TESTPLAN_RESOURCE_NAME));
        HttpResponse response = this.executeRequest(getFolderTreeRequest);
        String testPlan = IOUtils.toString(response.getEntity().getContent());
        return PcTestPlanFolders.xmlToObject(testPlan);
    }

    public boolean verifyTestPlanFolderExist(String path) throws IOException, PcException {
        PcTestPlanFolders pcTestPlanFolders = this.getTestPlanFolders();
        if (pcTestPlanFolders != null) {
            for (PcTestPlanFolder pcTestPlanFolder : pcTestPlanFolders.getPcTestPlanFolderList()) {
                if (!pcTestPlanFolder.getFullPath().equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    public PcTestPlanFolder createTestPlanFolder(String existingPath, String name) throws IOException, PcException {
        PcTestPlanFolder pcTestPlanFolder;
        HttpPost createTestPlanFolderRequest = new HttpPost(String.format(this.baseURL + "/%s", TESTPLAN_RESOURCE_NAME));
        TestPlanFolderCreateRequest testPlanFolderCreateRequest = new TestPlanFolderCreateRequest(existingPath, name);
        createTestPlanFolderRequest.setEntity(new StringEntity(testPlanFolderCreateRequest.objectToXML(), ContentType.APPLICATION_XML));
        createTestPlanFolderRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        HttpResponse response = this.executeRequest(createTestPlanFolderRequest);
        String responseXml = IOUtils.toString(response.getEntity().getContent());
        try {
            pcTestPlanFolder = testPlanFolderCreateRequest.getPcTestPlanFolderFromResponse(responseXml);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PcException("createTestPlanFolder exception: " + e);
        }
        return pcTestPlanFolder;
    }

    public ArrayList<PcTestPlanFolder> createTestPlanFolders(String[] paths) throws IOException, PcException {
        ArrayList<String[]> pathFromSubjectAndFolders = Helper.getArrayListOfStringArray(paths);
        PcTestPlanFolders pcTestPlanFolders = this.getTestPlanFolders();
        ArrayList<String[]> pathFromSubjectAndFoldersFiltered = Helper.getCleanAndNonExistingAndSortedArrayList(pathFromSubjectAndFolders, pcTestPlanFolders);
        return this.createPcTestPlanFolders(pathFromSubjectAndFoldersFiltered);
    }

    public ArrayList<PcTestPlanFolder> createPcTestPlanFolders(ArrayList<String[]> stringsOfExistingPathFromSubjectAndOfFolderToCreate) throws IOException, PcException {
        ArrayList<PcTestPlanFolder> createdPcTestPlanFolders = new ArrayList<PcTestPlanFolder>();
        if (stringsOfExistingPathFromSubjectAndOfFolderToCreate.size() > 0) {
            for (String[] pathFromSubjectAndFolder : stringsOfExistingPathFromSubjectAndOfFolderToCreate) {
                PcTestPlanFolder createdPcTestPlanFolder = this.createTestPlanFolder(pathFromSubjectAndFolder[0], pathFromSubjectAndFolder[1]);
                createdPcTestPlanFolders.add(createdPcTestPlanFolder);
            }
        }
        return createdPcTestPlanFolders;
    }

    public Test createOrUpdateTestFromYamlTest(String testString) throws IOException, PcException {
        SimplifiedTest simplifiedTest = PcRestProxy.xmlOrYamlStringToSimplifiedTest(testString);
        return this.createOrUpdateTestFromYamlContent("", "", testString);
    }

    public Test createOrUpdateTestFromYamlContent(String testName, String testFolderPath, String testOrContent) throws IOException, PcException {
        Test createdOrUpdatedTest = null;
        ConvertContentStringToTest convertContentStringToTest = new ConvertContentStringToTest(this, testName, testFolderPath, testOrContent).invoke();
        createdOrUpdatedTest = this.createOrUpdateTest(convertContentStringToTest.getTestName(), convertContentStringToTest.getTestFolderPathWithSubject(), convertContentStringToTest.getContent());
        return createdOrUpdatedTest;
    }

    public Test createOrUpdateTest(String testName, String testFolderPath, String xml) throws IOException, PcException {
        String testFolderPathWithCorrectSeparatorsAndSubject = testFolderPath.replace("/", "\\");
        if (!testFolderPath.startsWith("Subject")) {
            testFolderPathWithCorrectSeparatorsAndSubject = "Subject\\".concat(testFolderPath);
        }
        Content content = PcRestProxy.getContentFromXmlOrYamlString(xml);
        Test test = this.createOrUpdateTest(testName, testFolderPathWithCorrectSeparatorsAndSubject, content);
        return test;
    }

    public Test createOrUpdateTest(String testName, String testFolderPath, Content content) throws IOException, PcException {
        this.createTestPlanFolder(testFolderPath);
        try {
            HttpPost createTestRequest = new HttpPost(String.format(this.baseURL + "/%s", TESTS_RESOURCE_NAME));
            Test test = new Test(testName, testFolderPath, content);
            createTestRequest.setEntity(new StringEntity(test.objectToXML(), ContentType.APPLICATION_XML));
            HttpResponse response = this.executeRequest(createTestRequest);
            String createTestResponse = IOUtils.toString(response.getEntity().getContent());
            return Test.xmlToObject(createTestResponse);
        }
        catch (PcException e) {
            int testId = this.extractTestIdFromString(e.getMessage());
            if (testId != 0) {
                return this.updateTest(testId, content);
            }
            throw e;
        }
    }

    private void createTestPlanFolder(String testFolderPath) {
        try {
            if (!this.verifyTestPlanFolderExist(testFolderPath)) {
                String[] scriptPathArray = new String[]{testFolderPath};
                this.createTestPlanFolders(scriptPathArray);
            }
        }
        catch (PcException | IOException exception) {
            // empty catch block
        }
    }

    public Test getTest(int testId) throws IOException, PcException {
        HttpGet getTestRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        HttpResponse response = this.executeRequest(getTestRequest);
        String xmlTest = IOUtils.toString(response.getEntity().getContent());
        return Test.xmlToObject(xmlTest);
    }

    public Test updateTest(int testId, Content content) throws IOException, PcException {
        HttpPut updateTestRequest = new HttpPut(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        updateTestRequest.setEntity(new StringEntity(content.objectToXML(true), ContentType.APPLICATION_XML));
        HttpResponse response = this.executeRequest(updateTestRequest);
        Test updatedTest = this.getTest(testId);
        return updatedTest;
    }

    public boolean deleteTest(int testId) throws IOException, PcException {
        HttpDelete deleteTestRequest = new HttpDelete(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        HttpResponse response = this.executeRequest(deleteTestRequest);
        return true;
    }

    protected String getBaseURL() {
        return this.baseURL;
    }

    public int extractTestIdFromString(String value) {
        return Helper.extractTestIdFromString(value);
    }

    public Content readYaml(String yamlContent) throws IOException {
        Content content = null;
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            Test test = mapper.readValue(yamlContent, Test.class);
            content = test.getContent();
        }
        catch (IOException ex1) {
            content = mapper.readValue(yamlContent, Content.class);
        }
        return content;
    }

    public String GetPcServer() {
        return this.pcServer;
    }

    public String GetTenant() {
        return this.tenantSuffix;
    }
}

