/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.internal.token.ArrayPathToken;
import com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import com.jayway.jsonpath.internal.token.PathToken;
import com.jayway.jsonpath.internal.token.PredicatePathToken;
import com.jayway.jsonpath.internal.token.PropertyPathToken;
import com.jayway.jsonpath.internal.token.WildcardPathToken;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScanPathToken
extends PathToken {
    private static final Predicate FALSE_PREDICATE = new Predicate(){

        @Override
        public Class<?> clazz() {
            return null;
        }

        @Override
        public boolean matches(Object model) {
            return false;
        }
    };

    @Override
    public void evaluate(String currentPath, Object model, EvaluationContextImpl ctx) {
        if (this.isLeaf()) {
            ctx.addResult(currentPath, model);
        }
        Predicate predicate = ScanPathToken.createScanPredicate(this.next(), ctx);
        LinkedHashMap<String, Object> predicateMatches = new LinkedHashMap<String, Object>();
        ScanPathToken.walk(currentPath, model, ctx, predicate, predicateMatches);
        PathToken next = this.next();
        if (next instanceof PredicatePathToken) {
            if (next.isLeaf()) {
                for (Map.Entry match : predicateMatches.entrySet()) {
                    ctx.addResult((String)match.getKey(), match.getValue());
                }
                return;
            }
            next = next.next();
        }
        for (Map.Entry match : predicateMatches.entrySet()) {
            next.evaluate((String)match.getKey(), match.getValue(), ctx);
        }
    }

    public static void walk(String currentPath, Object model, EvaluationContextImpl ctx, Predicate predicate, Map<String, Object> predicateMatches) {
        if (ctx.jsonProvider().isMap(model)) {
            ScanPathToken.walkObject(currentPath, model, ctx, predicate, predicateMatches);
        } else if (ctx.jsonProvider().isArray(model)) {
            ScanPathToken.walkArray(currentPath, model, ctx, predicate, predicateMatches);
        }
    }

    public static void walkArray(String currentPath, Object model, EvaluationContextImpl ctx, Predicate predicate, Map<String, Object> predicateMatches) {
        if (predicate.matches(model)) {
            predicateMatches.put(currentPath, model);
        }
        Iterable<?> models = ctx.jsonProvider().toIterable(model);
        int idx = 0;
        for (Object evalModel : models) {
            String evalPath = currentPath + "[" + idx + "]";
            if (predicate.clazz().equals(PredicatePathToken.class) && predicate.matches(evalModel)) {
                predicateMatches.put(evalPath, evalModel);
            }
            ScanPathToken.walk(evalPath, evalModel, ctx, predicate, predicateMatches);
            ++idx;
        }
    }

    public static void walkObject(String currentPath, Object model, EvaluationContextImpl ctx, Predicate predicate, Map<String, Object> predicateMatches) {
        if (predicate.matches(model)) {
            predicateMatches.put(currentPath, model);
        }
        Collection<String> properties = ctx.jsonProvider().getPropertyKeys(model);
        for (String property : properties) {
            String evalPath = currentPath + "['" + property + "']";
            Object propertyModel = ctx.jsonProvider().getMapValue(model, property);
            if (propertyModel == JsonProvider.UNDEFINED) continue;
            ScanPathToken.walk(evalPath, propertyModel, ctx, predicate, predicateMatches);
        }
    }

    private static Predicate createScanPredicate(PathToken target, EvaluationContextImpl ctx) {
        if (target instanceof PropertyPathToken) {
            return new PropertyPathTokenPredicate(target, ctx);
        }
        if (target instanceof ArrayPathToken) {
            return new ArrayPathTokenPredicate(ctx);
        }
        if (target instanceof WildcardPathToken) {
            return new WildcardPathTokenPredicate();
        }
        if (target instanceof PredicatePathToken) {
            return new FilterPathTokenPredicate(target, ctx);
        }
        return FALSE_PREDICATE;
    }

    @Override
    boolean isTokenDefinite() {
        return false;
    }

    @Override
    public String getPathFragment() {
        return "..";
    }

    private static final class PropertyPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;
        private PropertyPathToken propertyPathToken;

        private PropertyPathTokenPredicate(PathToken target, EvaluationContextImpl ctx) {
            this.ctx = ctx;
            this.propertyPathToken = (PropertyPathToken)target;
        }

        @Override
        public Class<?> clazz() {
            return PropertyPathToken.class;
        }

        @Override
        public boolean matches(Object model) {
            if (this.ctx.jsonProvider().isMap(model)) {
                Collection<String> keys = this.ctx.jsonProvider().getPropertyKeys(model);
                return keys.containsAll(this.propertyPathToken.getProperties());
            }
            return false;
        }
    }

    private static final class ArrayPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;

        private ArrayPathTokenPredicate(EvaluationContextImpl ctx) {
            this.ctx = ctx;
        }

        @Override
        public Class<?> clazz() {
            return ArrayPathToken.class;
        }

        @Override
        public boolean matches(Object model) {
            return this.ctx.jsonProvider().isArray(model);
        }
    }

    private static final class WildcardPathTokenPredicate
    implements Predicate {
        private WildcardPathTokenPredicate() {
        }

        @Override
        public Class<?> clazz() {
            return WildcardPathToken.class;
        }

        @Override
        public boolean matches(Object model) {
            return true;
        }
    }

    private static final class FilterPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;
        private PredicatePathToken predicatePathToken;

        private FilterPathTokenPredicate(PathToken target, EvaluationContextImpl ctx) {
            this.ctx = ctx;
            this.predicatePathToken = (PredicatePathToken)target;
        }

        @Override
        public Class<?> clazz() {
            return PredicatePathToken.class;
        }

        @Override
        public boolean matches(Object model) {
            return this.predicatePathToken.accept(model, this.ctx.rootDocument(), this.ctx.configuration(), this.ctx);
        }
    }

    private static interface Predicate {
        public Class<?> clazz();

        public boolean matches(Object var1);
    }
}

