/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.http.HttpProviderFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class JsonReader
implements ParseContext,
ReadContext {
    private final Configuration configuration;
    private Object json;

    public JsonReader() {
        this(Configuration.defaultConfiguration());
    }

    public JsonReader(Configuration configuration) {
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.configuration = configuration;
    }

    @Override
    public ReadContext parse(Object json) {
        Utils.notNull(json, "json object can not be null", new Object[0]);
        this.json = json;
        return this;
    }

    @Override
    public ReadContext parse(String json) {
        Utils.notEmpty(json, "json string can not be null or empty", new Object[0]);
        this.json = this.configuration.jsonProvider().parse(json);
        return this;
    }

    @Override
    public ReadContext parse(InputStream json) {
        return this.parse(json, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadContext parse(InputStream json, String charset) {
        Utils.notNull(json, "json input stream can not be null", new Object[0]);
        Utils.notNull(json, "charset can not be null", new Object[0]);
        try {
            this.json = this.configuration.jsonProvider().parse(json, charset);
            JsonReader jsonReader = this;
            return jsonReader;
        }
        finally {
            Utils.closeQuietly(json);
        }
    }

    @Override
    public ReadContext parse(File json) throws IOException {
        Utils.notNull(json, "json file can not be null", new Object[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(json);
            this.parse(fis);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return this;
    }

    @Override
    public ReadContext parse(URL json) throws IOException {
        Utils.notNull(json, "json url can not be null", new Object[0]);
        InputStream is = HttpProviderFactory.getProvider().get(json);
        return this.parse(is);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Object json() {
        return this.json;
    }

    @Override
    public <T> T read(String path, Predicate ... filters) {
        Utils.notEmpty(path, "path can not be null or empty", new Object[0]);
        return this.read(JsonPath.compile(path, filters));
    }

    @Override
    public <T> T read(String path, Class<T> type, Predicate ... filters) {
        return this.convert(this.read(path, filters), type, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path) {
        Utils.notNull(path, "path can not be null", new Object[0]);
        return path.read(this.json, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path, Class<T> type) {
        return this.convert(this.read(path), type, this.configuration);
    }

    private <T> T convert(Object obj, Class<T> targetType, Configuration configuration) {
        return configuration.mappingProvider().map(obj, targetType, configuration);
    }
}

