/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidCriteriaException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ValueCompareException;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathCompiler;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.PredicateContextImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Criteria
implements Predicate {
    private static final Logger logger = LoggerFactory.getLogger(Criteria.class);
    private final Path path;
    private CriteriaType criteriaType;
    private Object expected;
    private final List<Criteria> criteriaChain;

    private Criteria(List<Criteria> criteriaChain, Path path) {
        if (!path.isDefinite()) {
            throw new InvalidCriteriaException("A criteria path must be definite. The path " + path.toString() + " is not!");
        }
        this.path = path;
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
    }

    private Criteria(Path path) {
        this(new LinkedList<Criteria>(), path);
    }

    private Criteria(Path path, CriteriaType criteriaType, Object expected) {
        this(new LinkedList<Criteria>(), path);
        this.criteriaType = criteriaType;
        this.expected = expected;
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        for (Criteria criteria : this.criteriaChain) {
            if (criteria.eval(ctx)) continue;
            return false;
        }
        return true;
    }

    private boolean eval(Predicate.PredicateContext ctx) {
        if (CriteriaType.EXISTS == this.criteriaType) {
            boolean exists = (Boolean)this.expected;
            try {
                Configuration c = Configuration.builder().jsonProvider(ctx.configuration().jsonProvider()).options(Option.REQUIRE_PROPERTIES).build();
                this.path.evaluate(ctx.item(), ctx.root(), c).getValue();
                return exists;
            }
            catch (PathNotFoundException e) {
                return !exists;
            }
        }
        try {
            Object actual = this.path.evaluate(ctx.item(), ctx.root(), ctx.configuration()).getValue();
            Object expectedVal = this.expected;
            if (this.expected instanceof Path) {
                Path expectedPath = (Path)this.expected;
                if (ctx instanceof PredicateContextImpl) {
                    PredicateContextImpl ctxi = (PredicateContextImpl)ctx;
                    expectedVal = ctxi.evaluate(expectedPath);
                } else {
                    Object doc = expectedPath.isRootPath() ? ctx.root() : ctx.item();
                    expectedVal = expectedPath.evaluate(doc, ctx.root(), ctx.configuration()).getValue();
                }
            }
            return this.criteriaType.eval(expectedVal, actual, ctx);
        }
        catch (ValueCompareException e) {
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public static Criteria where(Path key) {
        return new Criteria(key);
    }

    public static Criteria where(String key) {
        return Criteria.where(PathCompiler.compile(key, new Predicate[0]));
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, PathCompiler.compile(key, new Predicate[0]));
    }

    public Criteria is(Object o) {
        this.criteriaType = CriteriaType.EQ;
        this.expected = o;
        return this;
    }

    public Criteria eq(Object o) {
        return this.is(o);
    }

    public Criteria ne(Object o) {
        this.criteriaType = CriteriaType.NE;
        this.expected = o;
        return this;
    }

    public Criteria lt(Object o) {
        this.criteriaType = CriteriaType.LT;
        this.expected = o;
        return this;
    }

    public Criteria lte(Object o) {
        this.criteriaType = CriteriaType.LTE;
        this.expected = o;
        return this;
    }

    public Criteria gt(Object o) {
        this.criteriaType = CriteriaType.GT;
        this.expected = o;
        return this;
    }

    public Criteria gte(Object o) {
        this.criteriaType = CriteriaType.GTE;
        this.expected = o;
        return this;
    }

    public Criteria regex(Pattern pattern) {
        Utils.notNull(pattern, "pattern can not be null", new Object[0]);
        this.criteriaType = CriteriaType.REGEX;
        this.expected = pattern;
        return this;
    }

    public Criteria in(Object ... o) {
        return this.in(Arrays.asList(o));
    }

    public Criteria in(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.IN;
        this.expected = c;
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.NIN;
        this.expected = c;
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.ALL;
        this.expected = c;
        return this;
    }

    public Criteria size(int size) {
        this.criteriaType = CriteriaType.SIZE;
        this.expected = size;
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteriaType = CriteriaType.EXISTS;
        this.expected = b;
        return this;
    }

    public Criteria type(Class<?> t) {
        Utils.notNull(t, "type can not be null", new Object[0]);
        this.criteriaType = CriteriaType.TYPE;
        this.expected = t;
        return this;
    }

    public Criteria notEmpty() {
        this.criteriaType = CriteriaType.NOT_EMPTY;
        this.expected = null;
        return this;
    }

    public Criteria matches(Predicate p) {
        this.criteriaType = CriteriaType.MATCHES;
        this.expected = p;
        return this;
    }

    public static Criteria create(String path, String operator2, String expected) {
        if (!expected.isEmpty() && expected.charAt(0) == '\'' && expected.charAt(expected.length() - 1) == '\'') {
            expected = expected.substring(1, expected.length() - 1);
        }
        Path p = PathCompiler.compile(path, new Predicate[0]);
        if (("$".equals(path) || "@".equals(path)) && (operator2 == null || operator2.isEmpty()) && (expected == null || expected.isEmpty())) {
            return new Criteria(p, CriteriaType.NE, null);
        }
        if (operator2.isEmpty()) {
            return Criteria.where(path).exists(true);
        }
        if (expected.startsWith("$") || expected.startsWith("@")) {
            Path compile = PathCompiler.compile(expected, new Predicate[0]);
            if (!compile.isDefinite()) {
                throw new InvalidPathException("the predicate path: " + expected + " is not definite");
            }
            return new Criteria(p, CriteriaType.parse(operator2), compile);
        }
        return new Criteria(p, CriteriaType.parse(operator2), expected);
    }

    private static int safeCompare(Object expected, Object providerParsed) throws ValueCompareException {
        if (expected == providerParsed) {
            return 0;
        }
        boolean expNullish = Criteria.isNullish(expected);
        boolean provNullish = Criteria.isNullish(providerParsed);
        if (expNullish && !provNullish) {
            return -1;
        }
        if (!expNullish && provNullish) {
            return 1;
        }
        if (expNullish && provNullish) {
            return 0;
        }
        if (expected instanceof String && providerParsed instanceof String) {
            return ((String)expected).compareTo((String)providerParsed);
        }
        if (expected instanceof Number && providerParsed instanceof Number) {
            return new BigDecimal(expected.toString()).compareTo(new BigDecimal(providerParsed.toString()));
        }
        if (expected instanceof String && providerParsed instanceof Number) {
            return new BigDecimal(expected.toString()).compareTo(new BigDecimal(providerParsed.toString()));
        }
        if (expected instanceof String && providerParsed instanceof Boolean) {
            Boolean e = Boolean.valueOf((String)expected);
            Boolean a = (Boolean)providerParsed;
            return e.compareTo(a);
        }
        if (expected instanceof Boolean && providerParsed instanceof Boolean) {
            Boolean e = (Boolean)expected;
            Boolean a = (Boolean)providerParsed;
            return e.compareTo(a);
        }
        logger.debug("Can not compare a {} with a {}", (Object)expected.getClass().getName(), (Object)providerParsed.getClass().getName());
        throw new ValueCompareException();
    }

    private static boolean isNullish(Object o) {
        return o == null || o instanceof String && "null".equals(o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path.toString()).append("|").append(this.criteriaType.name()).append("|").append(this.expected).append("|");
        return sb.toString();
    }

    private static enum CriteriaType {
        EQ{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                boolean bl = res = 0 == Criteria.safeCompare(expected, actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected, res);
                }
                return res;
            }
        }
        ,
        NE{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                boolean bl = res = 0 != Criteria.safeCompare(expected, actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected, res);
                }
                return res;
            }
        }
        ,
        GT{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean bl = res = 0 > Criteria.safeCompare(expected, actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected, res);
                }
                return res;
            }
        }
        ,
        GTE{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean bl = res = 0 >= Criteria.safeCompare(expected, actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected, res);
                }
                return res;
            }
        }
        ,
        LT{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean bl = res = 0 < Criteria.safeCompare(expected, actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected, res);
                }
                return res;
            }
        }
        ,
        LTE{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ actual == null) {
                    return false;
                }
                boolean bl = res = 0 <= Criteria.safeCompare(expected, actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected, res);
                }
                return res;
            }
        }
        ,
        IN{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res = false;
                Collection exps = (Collection)expected;
                for (Object exp : exps) {
                    if (0 != Criteria.safeCompare(exp, actual)) continue;
                    res = true;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), Utils.join(", ", exps), res);
                }
                return res;
            }
        }
        ,
        NIN{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                Collection nexps = (Collection)expected;
                boolean bl = res = !nexps.contains(actual);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), Utils.join(", ", nexps), res);
                }
                return res;
            }
        }
        ,
        ALL{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res = true;
                Collection exps = (Collection)expected;
                if (ctx.configuration().jsonProvider().isArray(actual)) {
                    for (Object exp : exps) {
                        boolean found = false;
                        for (Object check : ctx.configuration().jsonProvider().toIterable(actual)) {
                            if (0 != Criteria.safeCompare(exp, check)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        res = false;
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] {} [{}] => {}", Utils.join(", ", ctx.configuration().jsonProvider().toIterable(actual)), this.name(), Utils.join(", ", exps), res);
                    }
                } else {
                    res = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] {} [{}] => {}", "<NOT AN ARRAY>", this.name(), Utils.join(", ", exps), res);
                    }
                }
                return res;
            }
        }
        ,
        SIZE{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res;
                int size = (Integer)expected;
                if (ctx.configuration().jsonProvider().isArray(actual)) {
                    int length = ctx.configuration().jsonProvider().length(actual);
                    boolean bl = res = length == size;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Array with size {} {} {} => {}", length, this.name(), size, res);
                    }
                } else if (actual instanceof String) {
                    int length = ((String)actual).length();
                    boolean bl = res = length == size;
                    if (logger.isDebugEnabled()) {
                        logger.debug("String with length {} {} {} => {}", length, this.name(), size, res);
                    }
                } else {
                    res = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} {} {} => {}", actual == null ? "null" : actual.getClass().getName(), this.name(), size, res);
                    }
                }
                return res;
            }
        }
        ,
        EXISTS{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        TYPE{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                Class expType = (Class)expected;
                Class<?> actType = actual == null ? null : actual.getClass();
                return actType != null && expType.isAssignableFrom(actType);
            }
        }
        ,
        REGEX{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res = false;
                Pattern pattern = (Pattern)expected;
                if (actual != null && actual instanceof String) {
                    res = pattern.matcher(actual.toString()).matches();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", actual, this.name(), expected.toString(), res);
                }
                return res;
            }
        }
        ,
        MATCHES{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                PredicateContextImpl pci = (PredicateContextImpl)ctx;
                Predicate exp = (Predicate)expected;
                return exp.apply(new PredicateContextImpl(actual, ctx.root(), ctx.configuration(), pci.documentPathCache()));
            }
        }
        ,
        NOT_EMPTY{

            @Override
            boolean eval(Object expected, Object actual, Predicate.PredicateContext ctx) {
                boolean res = false;
                if (actual != null) {
                    if (ctx.configuration().jsonProvider().isArray(actual)) {
                        int len = ctx.configuration().jsonProvider().length(actual);
                        boolean bl = res = 0 != len;
                        if (logger.isDebugEnabled()) {
                            logger.debug("array length = {} {} => {}", len, this.name(), res);
                        }
                    } else if (actual instanceof String) {
                        int len = ((String)actual).length();
                        boolean bl = res = 0 != len;
                        if (logger.isDebugEnabled()) {
                            logger.debug("string length = {} {} => {}", len, this.name(), res);
                        }
                    }
                }
                return res;
            }
        };


        abstract boolean eval(Object var1, Object var2, Predicate.PredicateContext var3);

        public static CriteriaType parse(String str) {
            if ("==".equals(str)) {
                return EQ;
            }
            if (">".equals(str)) {
                return GT;
            }
            if (">=".equals(str)) {
                return GTE;
            }
            if ("<".equals(str)) {
                return LT;
            }
            if ("<=".equals(str)) {
                return LTE;
            }
            if ("!=".equals(str)) {
                return NE;
            }
            throw new UnsupportedOperationException("CriteriaType " + str + " can not be parsed");
        }
    }
}

