/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.entities.impl;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.entities.ResponseEntityList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityImpl
implements Entity {
    private static final String COLLECTION_TOTAL_COUNT_FIELD = "total_count";
    private static final String COLLECTION_DATA_FIELD = "data";
    private Map<String, Object> fields = new HashMap<String, Object>();
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();

    @Override
    public Object getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    @Override
    @JsonAnySetter
    public Entity setField(String fieldName, Object fieldValue) {
        Object myFieldValue = fieldValue;
        if (fieldValue instanceof Map) {
            Map map = (Map)fieldValue;
            if (map.containsKey("type")) {
                myFieldValue = this.deserializeEntityFromMap(map);
            } else if (map.containsKey(COLLECTION_DATA_FIELD) && map.containsKey(COLLECTION_TOTAL_COUNT_FIELD)) {
                myFieldValue = this.deserializeEntityListFromMap(map);
            }
        }
        this.fields.put(fieldName, myFieldValue);
        return this;
    }

    private ResponseEntityList deserializeEntityListFromMap(Map<String, Object> map) {
        ResponseEntityList list = dtoFactory.newDTO(ResponseEntityList.class);
        list.setTotalCount((Integer)map.get(COLLECTION_TOTAL_COUNT_FIELD));
        List data = (List)map.get(COLLECTION_DATA_FIELD);
        for (Map entry : data) {
            Entity entity = this.deserializeEntityFromMap(entry);
            list.addEntity(entity);
        }
        return list;
    }

    private Entity deserializeEntityFromMap(Map<String, Object> map) {
        Entity entity = dtoFactory.newDTO(Entity.class);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entity.setField(entry.getKey(), entry.getValue());
        }
        return entity;
    }

    @Override
    public String getId() {
        return (String)this.getField("id");
    }

    @Override
    public Entity setId(String id) {
        this.setField("id", id);
        return this;
    }

    @Override
    public String getName() {
        return (String)this.getField("name");
    }

    @Override
    public Entity setName(String name) {
        this.setField("name", name);
        return this;
    }

    @Override
    public String getType() {
        return (String)this.getField("type");
    }

    @Override
    public Entity setType(String type) {
        this.setField("type", type);
        return this;
    }

    @Override
    public String getStringValue(String fieldName) {
        return (String)this.getField(fieldName);
    }

    @Override
    public Long getLongValue(String fieldName) {
        return (Long)this.getField(fieldName);
    }

    @Override
    public Entity getEntityValue(String fieldName) {
        return (Entity)this.getField(fieldName);
    }

    @Override
    public Boolean getBooleanValue(String fieldName) {
        return (Boolean)this.getField(fieldName);
    }

    @Override
    public boolean containsField(String fieldName) {
        return this.getFields().containsKey(fieldName);
    }

    @Override
    public boolean containsFieldAndValue(String fieldName) {
        return this.getFields().containsKey(fieldName) && this.getFields().get(fieldName) != null;
    }

    @JsonValue
    public Map<String, Object> getFields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fields.containsKey("type")) {
            sb.append(this.getType());
        }
        if (this.fields.containsKey("type")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("#");
            sb.append(this.getId());
        }
        if (this.fields.containsKey("name")) {
            if (sb.length() > 0) {
                sb.append(" - ");
            }
            sb.append(this.getName());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return super.toString();
    }
}

