/*
 * Decompiled with CFR 0.152.
 */
package com.adm.utils.uft.sdk.handler;

import com.adm.utils.uft.StringUtils;
import com.adm.utils.uft.XPathUtils;
import com.adm.utils.uft.sdk.Client;
import com.adm.utils.uft.sdk.Logger;
import com.adm.utils.uft.sdk.Response;
import com.adm.utils.uft.sdk.handler.EventLogHandler;
import com.adm.utils.uft.sdk.handler.PollHandler;
import com.adm.utils.uft.sdk.request.GetLabRunEntityDataRequest;
import com.adm.utils.uft.sdk.request.PollTimeslotRequest;
import java.util.Arrays;
import java.util.List;

public class LabPollHandler
extends PollHandler {
    private static final List<String> FINAL_STATES = Arrays.asList("Finished", "Aborted", "Stopped");
    private EventLogHandler _eventLogHandler;

    public LabPollHandler(Client client, String entityId) {
        super(client, entityId);
    }

    public LabPollHandler(Client client, String entityId, int interval) {
        super(client, entityId, interval);
    }

    @Override
    protected boolean doPoll(Logger logger) throws InterruptedException {
        boolean ret = false;
        Response runEntityResponse = this.getRunEntityData();
        if (this.isOk(runEntityResponse, logger)) {
            this.setTimeslotId(runEntityResponse, logger);
            this._eventLogHandler = new EventLogHandler(this._client, this._timeslotId);
            if (!StringUtils.isNullOrEmpty(this._timeslotId)) {
                ret = super.doPoll(logger);
            }
        }
        return ret;
    }

    @Override
    protected Response getResponse() {
        return new PollTimeslotRequest(this._client, this._timeslotId).execute();
    }

    @Override
    protected void log(Logger logger) {
        this._eventLogHandler.log(logger);
    }

    @Override
    protected boolean isFinished(Response response, Logger logger) {
        boolean ret = false;
        try {
            String xml = response.toString();
            String currentRunState = XPathUtils.getAttributeValue(xml, "current-run-state");
            if (FINAL_STATES.contains(currentRunState)) {
                String startTime = XPathUtils.getAttributeValue(xml, "start-time");
                String endTime = XPathUtils.getAttributeValue(xml, "end-time");
                logger.log(String.format("Timeslot %s is %s.\nTimeslot start time: %s, Timeslot end time: %s", this._timeslotId, currentRunState, startTime, endTime));
                ret = true;
            }
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response: %s", response));
            ret = true;
        }
        return ret;
    }

    @Override
    protected boolean logRunEntityResults(Response response, Logger logger) {
        boolean ret = false;
        try {
            String xml = response.toString();
            String state = XPathUtils.getAttributeValue(xml, "state");
            String completedSuccessfully = XPathUtils.getAttributeValue(xml, "completed-successfully");
            logger.log(String.format("Run state of %s: %s, Completed successfully: %s", this._runId, state, completedSuccessfully));
            ret = true;
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response: %s", response));
        }
        return ret;
    }

    private void setTimeslotId(Response runEntityResponse, Logger logger) {
        this._timeslotId = this.getTimeslotId(runEntityResponse, logger);
        if (!StringUtils.isNullOrEmpty(this._timeslotId)) {
            logger.log(String.format("Timeslot id: %s", this._timeslotId));
        }
    }

    private Response getRunEntityData() {
        return new GetLabRunEntityDataRequest(this._client, this._runId).execute();
    }

    private String getTimeslotId(Response response, Logger logger) {
        String ret = "";
        try {
            String xml = response.toString();
            ret = XPathUtils.getAttributeValue(xml, "reservation-id");
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response for timeslot ID: %s", response));
        }
        return ret;
    }

    @Override
    protected Response getRunEntityResultsResponse() {
        return new GetLabRunEntityDataRequest(this._client, this._runId).execute();
    }
}

